/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockCompDrawers
extends BlockDrawers
implements INetworked,
IFramedSourceBlock {
    public static final EnumProperty<EnumCompDrawer> SLOTS = EnumProperty.m_61587_((String)"slots", EnumCompDrawer.class);

    public BlockCompDrawers(int drawerCount, boolean halfDepth, Supplier<IDrawerConfig> drawerConfig, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, drawerConfig, properties);
    }

    @Deprecated
    public BlockCompDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    @Deprecated
    public BlockCompDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, BlockCompDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 16 : 32;
    }

    @Deprecated
    public BlockCompDrawers(int storageUnits, BlockBehaviour.Properties properties) {
        super(3, false, storageUnits, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SLOTS, (Comparable)((Object)EnumCompDrawer.OPEN1)));
    }

    @Deprecated
    public BlockCompDrawers(BlockBehaviour.Properties properties) {
        this(3, false, properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SLOTS});
    }

    @Override
    protected int getFaceSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        if (!this.hitWithinArea(correctSide, normalizedHit, 0.0625f, 0.9375f)) {
            return super.getFaceSlot(correctSide, normalizedHit);
        }
        if (this.hitWithinY(normalizedHit, 0.5f, 1.0f)) {
            return 0;
        }
        if (this.getDrawerCount() == 2) {
            return 1;
        }
        if (this.getDrawerCount() == 3) {
            if (this.hitWithinX(correctSide, normalizedHit, 0.0f, 0.5f)) {
                return 1;
            }
            return 2;
        }
        return super.getFaceSlot(correctSide, normalizedHit);
    }

    @Override
    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntityDrawersComp blockEntity = WorldUtils.getBlockEntity((BlockGetter)world, pos, BlockEntityDrawersComp.class);
        if (blockEntity != null) {
            IDrawerGroup group = blockEntity.getGroup();
            for (int i = group.getDrawerCount() - 1; i >= 0; --i) {
                if (group.getDrawer(i).isEmpty()) continue;
                world.m_7731_(pos, (BlockState)state.m_61124_(SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(i + 1))), 3);
                break;
            }
        }
    }

    public BlockEntityDrawers newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (BlockEntityDrawers)ModServices.RESOURCE_FACTORY.createBlockEntityDrawersComp(this.getDrawerCount()).m_155267_(pos, state);
    }

    @Override
    public ItemStack makeFramedItem(ItemStack source, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        IFramedBlock frameBlock;
        switch (this.getDrawerCount()) {
            case 2: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_2.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_2.get();
                break;
            }
            case 3: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_HALF_DRAWERS_3.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_COMPACTING_DRAWERS_3.get();
                break;
            }
            default: {
                IFramedBlock iFramedBlock = frameBlock = null;
            }
        }
        if (frameBlock == null) {
            return ItemStack.f_41583_;
        }
        return FrameHelper.makeFramedItem(frameBlock, source, matSide, matTrim, matFront);
    }
}

