/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.item.CustomCreativeOutput;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AutomobileComponentItem<T extends AutomobileComponent<T>>
extends Item
implements CustomCreativeOutput {
    protected final String nbtKey;
    protected final String translationKey;
    protected final SimpleMapContentRegistry<T> registry;

    public AutomobileComponentItem(Item.Properties settings, String nbtKey, String translationKey, SimpleMapContentRegistry<T> registry) {
        super(settings);
        this.nbtKey = nbtKey;
        this.translationKey = translationKey;
        this.registry = registry;
    }

    public ItemStack createStack(T component) {
        if (component.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setComponent(stack, component.getId());
        return stack;
    }

    public void setComponent(ItemStack stack, ResourceLocation component) {
        stack.m_41784_().m_128359_(this.nbtKey, component.toString());
    }

    public T getComponent(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(this.nbtKey)) {
            return (T)((AutomobileComponent)this.registry.getOrDefault(ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(this.nbtKey))));
        }
        return (T)((AutomobileComponent)this.registry.getOrDefault(null));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        T component = this.getComponent(stack);
        ResourceLocation id = component.getId();
        String compKey = id.m_135827_() + "." + id.m_135815_();
        tooltip.add((Component)Component.m_237115_((String)(this.translationKey + "." + compKey)).m_130940_(ChatFormatting.BLUE));
        component.appendTexts(tooltip, component);
    }

    @Override
    public void provideCreativeOutput(CreativeModeTab.Output output) {
        this.registry.forEach(component -> {
            if (this.addToCreative(component)) {
                output.m_246342_(this.createStack(component));
            }
        });
    }

    public boolean isVisible(T component) {
        return !component.isEmpty();
    }

    protected boolean addToCreative(T component) {
        return !component.isEmpty();
    }
}

