/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.entity;

import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.item.AutomobileEngineItem;
import io.github.foundationgames.automobility.item.AutomobileFrameItem;
import io.github.foundationgames.automobility.item.AutomobileWheelItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AutomobileAssemblerBlockEntity
extends BlockEntity
implements RenderableAutomobile {
    protected AutomobileFrame frame = AutomobileFrame.EMPTY;
    protected AutomobileEngine engine = AutomobileEngine.EMPTY;
    protected AutomobileWheel wheel = AutomobileWheel.EMPTY;
    protected int wheelCount = 0;
    public final List<Component> label = new ArrayList<Component>();
    protected final AutomobileStats stats = new AutomobileStats();

    public AutomobileAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super(AutomobilityBlocks.AUTOMOBILE_ASSEMBLER_ENTITY.require(), pos, state);
    }

    @Override
    public AutomobileFrame getFrame() {
        return this.frame;
    }

    @Override
    public AutomobileWheel getWheels() {
        return this.wheel;
    }

    @Override
    public AutomobileEngine getEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return null;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return null;
    }

    private void partChanged() {
        this.sync();
        this.m_6596_();
        this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), new GameEvent.Context(null, this.m_58900_()));
    }

    protected InteractionResult handleItemInteract(Player player, ItemStack stack) {
        Item item;
        if (stack.m_150930_(AutomobilityItems.CROWBAR.require())) {
            if (!this.f_58857_.m_5776_()) {
                this.dropParts();
                this.partChanged();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.frame.isEmpty() && (item = stack.m_41720_()) instanceof AutomobileFrameItem) {
            AutomobileFrameItem frameItem = (AutomobileFrameItem)item;
            if (!this.f_58857_.m_5776_()) {
                this.frame = (AutomobileFrame)frameItem.getComponent(stack);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.partChanged();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (!this.frame.isEmpty()) {
            if (this.engine.isEmpty() && (item = stack.m_41720_()) instanceof AutomobileEngineItem) {
                AutomobileEngineItem engineItem = (AutomobileEngineItem)item;
                if (!this.f_58857_.m_5776_()) {
                    this.engine = (AutomobileEngine)engineItem.getComponent(stack);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    this.partChanged();
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            item = stack.m_41720_();
            if (item instanceof AutomobileWheelItem) {
                AutomobileWheelItem wheelItem = (AutomobileWheelItem)item;
                if (!this.f_58857_.m_5776_()) {
                    AutomobileWheel wheelType = (AutomobileWheel)wheelItem.getComponent(stack);
                    if (this.wheel.isEmpty()) {
                        this.wheel = wheelType;
                        this.wheelCount = 0;
                    }
                    if (this.wheel == wheelType && this.wheelCount < this.frame.model().wheelBase().wheelCount) {
                        ++this.wheelCount;
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        this.partChanged();
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    return InteractionResult.PASS;
                }
            }
        }
        if (!this.f_58857_.m_5776_() && stack.m_150930_((Item)AutomobilityItems.FRONT_ATTACHMENT.require()) || stack.m_150930_((Item)AutomobilityItems.REAR_ATTACHMENT.require())) {
            player.m_5661_(AutomobileAssemblerBlock.INCOMPLETE_AUTOMOBILE_DIALOG, true);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult result = this.handleItemInteract(player, stack);
        if (!this.f_58857_.m_5776_() && result == InteractionResult.SUCCESS) {
            if (!this.isComplete()) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_144119_, SoundSource.BLOCKS, 0.7f, 0.6f + this.f_58857_.f_46441_.m_188501_() * 0.15f);
            }
            this.tryConstructAutomobile();
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    protected Vec3 centerPos() {
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.5);
    }

    public boolean isComplete() {
        return !this.frame.isEmpty() && !this.engine.isEmpty() && !this.wheel.isEmpty() && this.wheelCount >= this.frame.model().wheelBase().wheelCount;
    }

    public void tryConstructAutomobile() {
        if (this.isComplete()) {
            Vec3 pos = this.centerPos();
            AutomobileEntity auto = new AutomobileEntity(this.f_58857_);
            auto.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.getAutomobileYaw(0.0f), 0.0f);
            auto.setComponents(this.frame, this.wheel, this.engine);
            this.f_58857_.m_7967_((Entity)auto);
            this.f_58857_.m_6907_().forEach(p -> {
                if (p instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)p;
                    if (p.m_20183_().m_123331_((Vec3i)this.f_58858_) < 80000.0) {
                        player.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123813_, false, pos.f_82479_, pos.f_82480_ + 0.47, pos.f_82481_, 0.0f, 0.0f, 0.0f, 0.0f, 1));
                    }
                }
            });
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.23f, 0.5f);
            this.clear();
        }
    }

    public void dropParts() {
        Vec3 pos = this.centerPos();
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, AutomobilityItems.AUTOMOBILE_FRAME.require().createStack(this.getFrame())));
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, AutomobilityItems.AUTOMOBILE_ENGINE.require().createStack(this.getEngine())));
        ItemStack wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.require().createStack(this.getWheels());
        wheelStack.m_41764_(this.wheelCount);
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, wheelStack));
        this.clear();
    }

    public void clear() {
        this.frame = AutomobileFrame.EMPTY;
        this.wheel = AutomobileWheel.EMPTY;
        this.engine = AutomobileEngine.EMPTY;
        this.wheelCount = 0;
    }

    private boolean hasAllParts() {
        return !this.frame.isEmpty() && !this.wheel.isEmpty() && !this.engine.isEmpty();
    }

    private void onComponentsUpdated() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            this.label.clear();
            if (this.hasAllParts()) {
                this.stats.from(this.frame, this.wheel, this.engine);
                this.stats.appendTexts(this.label, this.stats);
            }
        }
    }

    private void sync() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            sWorld.m_7726_().m_8450_(this.f_58858_);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.frame = AutomobileFrame.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)nbt.m_128461_("frame")));
        this.engine = AutomobileEngine.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)nbt.m_128461_("engine")));
        CompoundTag wheelNbt = nbt.m_128469_("wheels");
        this.wheel = AutomobileWheel.REGISTRY.getOrDefault(ResourceLocation.m_135820_((String)wheelNbt.m_128461_("type")));
        this.wheelCount = wheelNbt.m_128451_("count");
        this.onComponentsUpdated();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("frame", this.frame.getId().toString());
        nbt.m_128359_("engine", this.engine.getId().toString());
        CompoundTag wheelNbt = new CompoundTag();
        wheelNbt.m_128359_("type", this.wheel.getId().toString());
        wheelNbt.m_128405_("count", this.wheelCount);
        nbt.m_128365_("wheels", (Tag)wheelNbt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    protected boolean powered() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return state.m_61138_((Property)AutomobileAssemblerBlock.POWERED) && (Boolean)state.m_61143_((Property)AutomobileAssemblerBlock.POWERED) != false;
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return state.m_61138_((Property)AutomobileAssemblerBlock.f_54117_) ? ((Direction)state.m_61143_((Property)AutomobileAssemblerBlock.f_54117_)).m_122435_() - 90.0f : 0.0f;
    }

    @Override
    public int getWheelCount() {
        return this.wheelCount;
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return this.powered() ? ((float)this.getTime() + tickDelta) * 36.0f : 0.0f;
    }

    @Override
    public float getSteering(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return this.powered();
    }

    @Override
    public int getBoostTimer() {
        return this.powered() ? 1 : 0;
    }

    @Override
    public int getTurboCharge() {
        return 0;
    }

    @Override
    public long getTime() {
        return this.f_58857_.m_46467_();
    }

    @Override
    public boolean automobileOnGround() {
        return false;
    }

    @Override
    public boolean debris() {
        return false;
    }

    @Override
    public Vector3f debrisColor() {
        return null;
    }
}

