/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.BaseChestRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.BlockRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChestRearAttachment
extends BaseChestRearAttachment
implements Container,
MenuProvider {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    public ChestRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity, BlockState block, @Nullable BiFunction<ContainerLevelAccess, BlockRearAttachment, MenuProvider> screenProvider) {
        super(type, entity, block, screenProvider);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        Vec3 pos = this.pos();
        this.inventory.forEach(s -> Containers.m_18992_((Level)this.world(), (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)s));
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void m_6596_() {
        this.automobile.markDirty();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public Component m_5446_() {
        return BaseChestRearAttachment.TITLE_CHEST;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return ChestMenu.m_39237_((int)syncId, (Inventory)inv, (Container)this);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public void m_5856_(Player player) {
        this.open(player);
    }

    public void m_5785_(Player player) {
        this.close(player);
    }

    @Override
    protected SoundEvent getOpenSound() {
        return SoundEvents.f_11749_;
    }

    @Override
    protected SoundEvent getCloseSound() {
        return SoundEvents.f_11747_;
    }

    @Override
    public void writeNbt(CompoundTag nbt) {
        super.writeNbt(nbt);
        nbt.m_128365_("Items", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inventory));
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Items"), this.inventory);
    }
}

