/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import com.google.common.collect.Lists;
import glitchcore.event.TickEvent;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;

public class RandomUpdateHandler {
    private static void adjustWeatherFrequency(Level world, Season.SubSeason subSeason) {
        if (!ModConfig.seasons.changeWeatherFrequency) {
            return;
        }
        ServerLevelData serverLevelData = (ServerLevelData)world.m_6106_();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        if (seasonProperties.canRain()) {
            if (!world.m_6106_().m_6533_() && serverLevelData.m_6531_() > seasonProperties.maxRainTime()) {
                serverLevelData.m_6399_(world.f_46441_.m_188503_(seasonProperties.maxRainTime() - seasonProperties.minRainTime()) + seasonProperties.minRainTime());
            }
        } else if (serverLevelData.m_6533_()) {
            serverLevelData.m_5565_(false);
        }
        if (seasonProperties.canThunder()) {
            if (!world.m_6106_().m_6534_() && serverLevelData.m_6558_() > seasonProperties.maxThunderTime()) {
                serverLevelData.m_6398_(world.f_46441_.m_188503_(seasonProperties.maxThunderTime() - seasonProperties.minThunderTime()) + seasonProperties.minThunderTime());
            }
        } else if (serverLevelData.m_6534_()) {
            serverLevelData.m_5557_(false);
        }
    }

    private static void meltInChunk(ChunkMap chunkMap, LevelChunk chunkIn, float meltChance) {
        ServerLevel world = chunkMap.f_140133_;
        ChunkPos chunkpos = chunkIn.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        if (meltChance > 0.0f && world.f_46441_.m_188501_() < meltChance) {
            BlockPos topAirPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, world.m_46496_(i, 0, j, 15));
            BlockPos topGroundPos = topAirPos.m_7495_();
            BlockState aboveGroundState = world.m_8055_(topAirPos);
            BlockState groundState = world.m_8055_(topGroundPos);
            Holder biome = world.m_204166_(topAirPos);
            Holder groundBiome = world.m_204166_(topGroundPos);
            if (!biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && SeasonHooks.getBiomeTemperature((Level)world, (Holder<Biome>)biome, topGroundPos) >= 0.15f && aboveGroundState.m_60734_() == Blocks.f_50125_) {
                world.m_46597_(topAirPos, Blocks.f_50016_.m_49966_());
            }
            if (!groundBiome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES) && SeasonHooks.getBiomeTemperature((Level)world, (Holder<Biome>)groundBiome, topGroundPos) >= 0.15f && groundState.m_60734_() == Blocks.f_50126_) {
                ((IceBlock)Blocks.f_50126_).m_54168_(groundState, (Level)world, topGroundPos);
            }
        }
    }

    public static void onWorldTick(TickEvent.Level event) {
        if (event.getPhase() != TickEvent.Phase.END || event.getLevel().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        float meltRand = seasonProperties.meltChance() / 100.0f;
        int rolls = seasonProperties.meltRolls();
        RandomUpdateHandler.adjustWeatherFrequency((Level)level, subSeason);
        if (rolls > 0 && meltRand > 0.0f && ModConfig.seasons.generateSnowAndIce && ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_())) {
            ChunkMap chunkMap = level.m_7726_().f_8325_;
            DistanceManager distanceManager = chunkMap.m_143145_();
            int l = distanceManager.m_140816_();
            ArrayList list = Lists.newArrayListWithCapacity((int)l);
            for (ChunkHolder chunkholder : chunkMap.m_140416_()) {
                LevelChunk levelchunk = chunkholder.m_140085_();
                if (levelchunk == null) continue;
                list.add(new ChunkAndHolder(levelchunk, chunkholder));
            }
            Collections.shuffle(list);
            for (ChunkAndHolder serverchunkcache$chunkandholder : list) {
                LevelChunk levelChunk = serverchunkcache$chunkandholder.chunk;
                ChunkPos chunkpos = levelChunk.m_7697_();
                if (!chunkMap.m_183879_(chunkpos) || !level.m_183438_(chunkpos.m_45588_())) continue;
                for (int i = 0; i < rolls; ++i) {
                    RandomUpdateHandler.meltInChunk(chunkMap, levelChunk, meltRand);
                }
            }
        }
    }

    record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

