/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.PlayerAbilityEnableCallback;
import io.github.ladysnake.pal.PlayerAbilityUpdatedCallback;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SimpleAbilityTracker
implements AbilityTracker {
    protected final Player player;
    protected final SortedSet<AbilitySource> abilitySources = new TreeSet<AbilitySource>();
    protected final PlayerAbility ability;

    public SimpleAbilityTracker(PlayerAbility ability, Player player) {
        this.ability = ability;
        this.player = player;
    }

    @Override
    public void addSource(AbilitySource abilitySource) {
        boolean wasEmpty = this.abilitySources.isEmpty();
        if (this.abilitySources.add(abilitySource) && wasEmpty && ((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) {
            this.updateState(true);
            this.sync();
        }
    }

    @Override
    public void removeSource(AbilitySource abilitySource) {
        if (this.abilitySources.remove(abilitySource) && this.abilitySources.isEmpty()) {
            this.updateState(false);
            this.sync();
        }
    }

    @Override
    public boolean isGrantedBy(AbilitySource abilitySource) {
        return this.abilitySources.contains(abilitySource);
    }

    @Override
    public AbilitySource getActiveSource() {
        return this.abilitySources.last();
    }

    @Override
    public void refresh(boolean syncVanilla) {
        this.updateState(this.shouldBeEnabled());
        if (syncVanilla || !(this instanceof VanillaAbilityTracker)) {
            this.sync();
        }
    }

    protected boolean shouldBeEnabled() {
        for (AbilitySource abilitySource : this.abilitySources) {
            if (!((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (AbilitySource abilitySource : this.abilitySources) {
            list.add((Object)StringTag.m_129297_((String)abilitySource.getId().toString()));
        }
        tag.m_128365_("ability_sources", (Tag)list);
    }

    @Override
    public void load(CompoundTag tag) {
        ListTag list = tag.m_128437_("ability_sources", 8);
        for (int i = 0; i < list.size(); ++i) {
            AbilitySource source = PalInternals.getSource(ResourceLocation.m_135820_((String)list.m_128778_(i)));
            if (source != null) {
                this.addSource(source);
                continue;
            }
            PalInternals.LOGGER.warn("Unknown ability source {} attached to {} for {}", (Object)list.m_128778_(i), (Object)this.player, (Object)this.ability);
        }
    }

    protected void updateState(boolean enabled) {
        ((PlayerAbilityUpdatedCallback)PlayerAbilityUpdatedCallback.event(this.ability).invoker()).onAbilityUpdated(this.player, enabled);
    }

    protected void sync() {
    }

    @Override
    public boolean isEnabled() {
        return !this.abilitySources.isEmpty();
    }
}

