/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import com.google.common.base.Suppliers;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import io.github.ladysnake.pal.impl.PalInternals;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class Pal
implements ModInitializer {
    public static void grantAbility(Player player, PlayerAbility ability, AbilitySource reason) {
        reason.grantTo(player, ability);
    }

    public static void revokeAbility(Player player, PlayerAbility ability, AbilitySource reason) {
        reason.revokeFrom(player, ability);
    }

    public static AbilitySource getAbilitySource(String namespace, String name) {
        return Pal.getAbilitySource(new ResourceLocation(namespace, name));
    }

    public static AbilitySource getAbilitySource(ResourceLocation abilitySourceId) {
        return PalInternals.registerSource(abilitySourceId, null, AbilitySource::new);
    }

    public static AbilitySource getAbilitySource(ResourceLocation abilitySourceId, int priority) {
        return PalInternals.registerSource(abilitySourceId, priority, AbilitySource::new);
    }

    public static PlayerAbility registerAbility(String namespace, String path, BiFunction<PlayerAbility, Player, AbilityTracker> factory) {
        return Pal.registerAbility(new ResourceLocation(namespace, path), factory);
    }

    public static PlayerAbility registerAbility(ResourceLocation abilityId, BiFunction<PlayerAbility, Player, AbilityTracker> factory) {
        return PalInternals.registerAbility(new PlayerAbility(Objects.requireNonNull(abilityId), Objects.requireNonNull(factory)));
    }

    public static boolean isAbilityRegistered(@Nullable ResourceLocation abilityId) {
        return PalInternals.isAbilityRegistered(abilityId);
    }

    public static Supplier<PlayerAbility> provideRegisteredAbility(ResourceLocation abilityId) {
        Objects.requireNonNull(abilityId, "abilityId cannot be null");
        return Suppliers.memoize(() -> Objects.requireNonNull(PalInternals.getAbility(abilityId), abilityId + " has not been registered"));
    }

    public void onInitialize() {
        new VanillaAbilities();
        PalInternals.loadConfig();
    }
}

