/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.util.ArrayUtil;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_7922;
import org.jetbrains.annotations.NotNull;

public class RegistryPalette<T>
implements IntIterable {
    private final class_2378<T> registry;
    private final int[] raw;
    private final int[] inverse;
    private final ValueView valueView;
    private int size;

    public RegistryPalette(class_2378<T> registry) {
        this.registry = registry;
        this.raw = ArrayUtil.ofSingle(-1, registry.method_10204());
        this.inverse = ArrayUtil.ofSingle(-1, registry.method_10204());
        this.size = 0;
        this.valueView = new ValueView();
    }

    public int find(int value) {
        return this.inverse[value];
    }

    private int add(int value) {
        this.raw[this.size] = value;
        this.inverse[value] = this.size++;
        Object object = this.registry.method_10200(value);
        this.valueView.values.add(object);
        return this.size - 1;
    }

    public int findOrAdd(int value) {
        int index = this.find(value);
        return index == -1 ? this.add(value) : index;
    }

    public int findOrAdd(T value) {
        return this.findOrAdd(this.registry.method_10206(value));
    }

    public int get(int index) {
        return this.raw[index];
    }

    @NotNull
    public IntIterator iterator() {
        return IntIterators.wrap((int[])this.raw, (int)0, (int)this.size);
    }

    public ValueView view() {
        return this.valueView;
    }

    public class ValueView
    implements class_2359<T> {
        private final T defaultValue;
        private final List<T> values;

        public ValueView() {
            Object object;
            class_2378 class_23782 = RegistryPalette.this.registry;
            if (class_23782 instanceof class_7922) {
                class_7922 defreg = (class_7922)class_23782;
                object = defreg.method_10223(defreg.method_10137());
            } else {
                object = RegistryPalette.this.registry.method_10200(0);
            }
            this.defaultValue = object;
            this.values = new ArrayList();
        }

        public class_2378<T> registry() {
            return RegistryPalette.this.registry;
        }

        public T method_10200(int index) {
            if (index >= this.values.size()) {
                Surveyor.LOGGER.error("[Surveyor] Palette view access at index {} for palette size {}! Returning garbage!", (Object)index, (Object)this.values.size());
                return this.defaultValue;
            }
            return this.values.get(index);
        }

        public int method_10206(T value) {
            return this.values.indexOf(value);
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.values.iterator();
        }

        public int method_10204() {
            return RegistryPalette.this.size;
        }
    }
}

