/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.C2SPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class SurveyorNetworking {
    public static Consumer<C2SPacket> C2S_SENDER = p -> {};

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownTerrainPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownTerrainPacket::read, SurveyorNetworking::handleKnownTerrain));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownStructuresPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownStructuresPacket::read, SurveyorNetworking::handleKnownStructures));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2SKnownLandmarksPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, C2SKnownLandmarksPacket::read, SurveyorNetworking::handleKnownLandmarks));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksAddedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksAddedPacket::read, SurveyorNetworking::handleLandmarksAdded));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SyncLandmarksRemovedPacket.ID, (sv, p, h, b, se) -> SurveyorNetworking.handleServer(p, b, SyncLandmarksRemovedPacket::read, SurveyorNetworking::handleLandmarksRemoved));
    }

    private static void handleKnownTerrain(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownTerrainPacket packet) {
        if (summary.terrain() == null || Surveyor.CONFIG.networking.terrain.atMost(NetworkMode.NONE)) {
            return;
        }
        Map<class_1923, BitSet> serverBits = summary.terrain().bitSet(SurveyorExploration.ofShared(player));
        Map<class_1923, BitSet> clientBits = packet.regionBits();
        serverBits.forEach((rPos, set) -> {
            if (clientBits.containsKey(rPos)) {
                set.andNot((BitSet)clientBits.get(rPos));
            }
            if (!set.isEmpty()) {
                SurveyorExploration personalExploration = SurveyorExploration.of(player);
                BitSet personalSet = personalExploration.limitTerrainBitset((class_5321<class_1937>)world.method_27983(), (class_1923)rPos, (BitSet)set.clone());
                if (!personalSet.isEmpty()) {
                    S2CUpdateRegionPacket.of(false, rPos, summary.terrain().getRegion((class_1923)rPos), personalSet).send(player);
                }
                set.andNot(personalSet);
                if (!set.isEmpty() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.GROUP)) {
                    S2CUpdateRegionPacket.of(true, rPos, summary.terrain().getRegion((class_1923)rPos), set).send(player);
                }
            }
        });
    }

    private static void handleKnownStructures(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownStructuresPacket packet) {
        if (summary.structures() == null || Surveyor.CONFIG.networking.structures.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<class_5321<class_3195>, class_1923> structures = summary.structures().keySet(SurveyorExploration.ofShared(player));
        packet.structureKeys().forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (structures.isEmpty()) {
            return;
        }
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        Multimap<class_5321<class_3195>, class_1923> personalStructures = personalExploration.limitStructureKeySet((class_5321<class_1937>)world.method_27983(), (Multimap<class_5321<class_3195>, class_1923>)HashMultimap.create(structures));
        if (!personalStructures.isEmpty()) {
            S2CStructuresAddedPacket.of(false, personalStructures, summary.structures()).send(player);
        }
        personalStructures.forEach((arg_0, arg_1) -> structures.remove(arg_0, arg_1));
        if (!structures.isEmpty() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.GROUP)) {
            S2CStructuresAddedPacket.of(true, structures, summary.structures()).send(player);
        }
    }

    private static void handleKnownLandmarks(class_3222 player, class_3218 world, WorldSummary summary, C2SKnownLandmarksPacket packet) {
        if (summary.landmarks() == null || Surveyor.CONFIG.networking.landmarks.atMost(NetworkMode.NONE)) {
            return;
        }
        Multimap<LandmarkType<?>, class_2338> landmarks = summary.landmarks().keySet(Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.GROUP) ? SurveyorExploration.ofShared(player) : SurveyorExploration.of(player));
        HashMultimap addLandmarks = HashMultimap.create(landmarks);
        packet.landmarks().forEach((arg_0, arg_1) -> ((Multimap)addLandmarks).remove(arg_0, arg_1));
        if (!addLandmarks.isEmpty()) {
            SyncLandmarksAddedPacket.of(addLandmarks, summary.landmarks()).send(player);
        }
        HashMultimap removeLandmarks = HashMultimap.create(packet.landmarks());
        landmarks.forEach((arg_0, arg_1) -> ((Multimap)removeLandmarks).remove(arg_0, arg_1));
        if (!removeLandmarks.isEmpty()) {
            new SyncLandmarksRemovedPacket((Multimap<LandmarkType<?>, class_2338>)removeLandmarks).send(player);
        }
    }

    private static void handleLandmarksAdded(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, player);
    }

    private static void handleLandmarksRemoved(class_3222 player, class_3218 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        HashMap changed = new HashMap();
        packet.landmarks().forEach((type, pos) -> {
            if (summary.landmarks().contains((LandmarkType<?>)type, (class_2338)pos) && Surveyor.getUuid(player).equals(summary.landmarks().get(type, (class_2338)pos).owner())) {
                summary.landmarks().removeForBatch(changed, (LandmarkType<?>)type, (class_2338)pos);
            }
        });
        if (!changed.isEmpty()) {
            summary.landmarks().handleChanged((class_1937)world, changed, false, player);
        }
    }

    private static <T extends C2SPacket> void handleServer(class_3222 player, class_2540 buf, Function<class_2540, T> reader, ServerPacketHandler<T> handler) {
        C2SPacket packet = (C2SPacket)reader.apply(buf);
        handler.handle(player, player.method_51469(), WorldSummary.of((class_1937)player.method_51469()), packet);
    }

    public static interface ServerPacketHandler<T> {
        public void handle(class_3222 var1, class_3218 var2, WorldSummary var3, T var4);
    }
}

