/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverBossRoom;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverDungeonBuilder;
import com.aetherteam.aether.world.structurepiece.silverdungeon.SilverTemplePiece;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;

public class SilverDungeonStructure
extends Structure {
    public static final Codec<SilverDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SilverDungeonStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("maxY").forGetter(o -> o.maxY), (App)Codec.INT.fieldOf("belowTerrain").forGetter(o -> o.belowTerrain), (App)Codec.INT.fieldOf("aboveTerrain").forGetter(o -> o.aboveTerrain), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)builder, SilverDungeonStructure::new));
    private final int maxY;
    private final int belowTerrain;
    private final int aboveTerrain;
    private final int minY;
    private final int rangeY;

    public SilverDungeonStructure(Structure.StructureSettings settings, int maxY, int belowTerrain, int aboveTerrain, int minY, int rangeY) {
        super(settings);
        this.maxY = maxY;
        this.belowTerrain = belowTerrain;
        this.aboveTerrain = aboveTerrain;
        this.minY = minY;
        this.rangeY = rangeY;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int height;
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        int x = chunkPos.m_151390_();
        int z = chunkPos.m_151393_();
        int maxHeight = this.maxY;
        int minHeight = chunkGenerator.m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, context.f_226624_()) - this.belowTerrain;
        if (random.m_188503_(5) < 3) {
            height = minHeight + this.aboveTerrain;
            if (height < maxHeight) {
                height += random.m_188503_(maxHeight - height);
            }
        } else {
            height = Math.max(minHeight, this.minY + random.m_188503_(this.rangeY));
        }
        BlockPos blockpos = new BlockPos(chunkPos.m_151390_(), height, chunkPos.m_151393_());
        return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, context, blockpos)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos input) {
        WorldgenRandom randomSource = context.f_226626_();
        Rotation rotation = Rotation.m_221990_((RandomSource)randomSource);
        Direction direction = rotation.m_55954_(Direction.SOUTH);
        StructureTemplateManager manager = context.f_226625_();
        BlockPos elevatedPos = input.m_5484_(rotation.m_55954_(Direction.NORTH), 54).m_5484_(rotation.m_55954_(Direction.WEST), 15);
        this.buildCloudBed(builder, (RandomSource)randomSource, elevatedPos, direction);
        SilverTemplePiece rear = new SilverTemplePiece(manager, "rear", elevatedPos, rotation);
        builder.m_142679_((StructurePiece)rear);
        BlockPos bossRoomPos = elevatedPos.m_7918_((direction.m_122429_() + direction.m_122431_()) * 5, 3, (direction.m_122431_() - direction.m_122429_()) * 5);
        SilverBossRoom bossRoom = new SilverBossRoom(manager, "boss_room", bossRoomPos, rotation);
        builder.m_142679_((StructurePiece)bossRoom);
        int xOffset = direction.m_122429_() * rear.m_73547_().m_71056_();
        int zOffset = direction.m_122431_() * rear.m_73547_().m_71058_();
        BlockPos offsetPos = elevatedPos.m_7918_(xOffset, 0, zOffset);
        SilverTemplePiece exterior = new SilverTemplePiece(manager, "skeleton", offsetPos, rotation);
        builder.m_142679_((StructurePiece)exterior);
        SilverDungeonBuilder grid = new SilverDungeonBuilder((RandomSource)randomSource, 3, 3, 3);
        grid.assembleDungeon(builder, manager, offsetPos, rotation, direction);
    }

    private void buildCloudBed(StructurePiecesBuilder builder, RandomSource random, BlockPos origin, Direction direction) {
        int zBounds;
        int xBounds;
        BlockPos.MutableBlockPos offset = origin.m_122032_().m_122184_(0, -1, 0);
        switch (direction) {
            case SOUTH: {
                xBounds = 50;
                zBounds = 77;
                offset.m_122184_(-10, 0, -11);
                break;
            }
            case NORTH: {
                xBounds = 50;
                zBounds = 77;
                offset.m_122184_(-40, 0, -66);
                break;
            }
            case EAST: {
                xBounds = 77;
                zBounds = 50;
                offset.m_122184_(-11, 0, -40);
                break;
            }
            case WEST: {
                xBounds = 77;
                zBounds = 50;
                offset.m_122184_(-66, 0, -10);
                break;
            }
            default: {
                xBounds = 77;
                zBounds = 50;
            }
        }
        HashMap<ChunkPos, Set> chunks = new HashMap<ChunkPos, Set>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int tries = 0; tries < 100; ++tries) {
            int x = offset.m_123341_() + random.m_188503_(xBounds);
            int y = offset.m_123342_();
            int z = offset.m_123343_() + random.m_188503_(zBounds);
            int xTendency = random.m_188503_(3) - 1;
            int zTendency = random.m_188503_(3) - 1;
            for (int n = 0; n < 10; ++n) {
                x += random.m_188503_(3) - 1 + xTendency;
                if (random.m_188499_()) {
                    y += random.m_188503_(3) - 1;
                }
                z += random.m_188503_(3) - 1 + zTendency;
                for (int x1 = x; x1 < x + random.m_188503_(4) + 3; ++x1) {
                    for (int y1 = y; y1 < y + random.m_188503_(1) + 2; ++y1) {
                        for (int z1 = z; z1 < z + random.m_188503_(4) + 3; ++z1) {
                            if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 + random.m_188503_(2)) continue;
                            BlockPos newPosition = new BlockPos(x1, y1, z1);
                            positions.add(newPosition);
                            chunks.computeIfAbsent(new ChunkPos(newPosition), pos -> new HashSet());
                        }
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            blockPosSet.addAll(positions.stream().filter(pos -> new ChunkPos(pos).equals(chunkPos)).toList());
            builder.m_142679_((StructurePiece)new LargeAercloudChunk((Set<BlockPos>)blockPosSet, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), new BoundingBox(chunkPos.m_45604_(), origin.m_123342_(), chunkPos.m_45605_(), chunkPos.m_45608_(), origin.m_123342_(), chunkPos.m_45609_()), direction));
        });
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, PiecesContainer pieces) {
        AABB chunkBounds = new AABB((double)chunkBox.m_162395_(), (double)chunkBox.m_162396_(), (double)chunkBox.m_162398_(), (double)chunkBox.m_162399_(), (double)chunkBox.m_162400_(), (double)chunkBox.m_162401_());
        level.m_45976_(ValkyrieQueen.class, chunkBounds).forEach(queen -> {
            BoundingBox box = pieces.m_192756_();
            AABB dungeonBounds = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)(box.m_162400_() + 1), (double)(box.m_162401_() + 1));
            queen.setDungeonBounds(dungeonBounds);
        });
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AetherStructureTypes.SILVER_DUNGEON.get();
    }
}

