/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.base;

import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.internal.base.ComponentsInternals;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractComponentContainer
implements ComponentContainer {
    public static final String NBT_KEY = "cardinal_components";

    @Override
    public void copyFrom(ComponentContainer other) {
        for (ComponentKey<?> key : this.keys()) {
            Object theirs = key.getInternal(other);
            Object ours = key.getInternal(this);
            assert (ours != null);
            if (theirs == null || ours.equals(theirs)) continue;
            if (ours instanceof CopyableComponent) {
                CopyableComponent copyable = (CopyableComponent)ours;
                copyable.copyFrom(theirs);
                continue;
            }
            CompoundTag tag = new CompoundTag();
            theirs.writeToNbt(tag);
            ours.readFromNbt(tag);
        }
    }

    @Override
    public void fromTag(CompoundTag tag) {
        if (tag.m_128425_(NBT_KEY, 9)) {
            ListTag componentList = tag.m_128437_(NBT_KEY, 10);
            for (int i = 0; i < componentList.size(); ++i) {
                Object component;
                CompoundTag nbt = componentList.m_128728_(i);
                ComponentKey<?> type = ComponentRegistry.get(new ResourceLocation(nbt.m_128461_("componentId")));
                if (type == null || (component = type.getInternal(this)) == null) continue;
                component.readFromNbt(nbt);
            }
        } else if (tag.m_128425_(NBT_KEY, 10)) {
            CompoundTag componentMap = tag.m_128469_(NBT_KEY);
            for (ComponentKey<?> key : this.keys()) {
                String keyId = key.getId().toString();
                if (!componentMap.m_128425_(keyId, 10)) continue;
                Object component = key.getInternal(this);
                assert (component != null);
                component.readFromNbt(componentMap.m_128469_(keyId));
                componentMap.m_128473_(keyId);
            }
            ComponentsInternals.logDeserializationWarnings(componentMap.m_128431_());
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        if (this.hasComponents()) {
            CompoundTag componentMap = null;
            CompoundTag componentTag = new CompoundTag();
            for (ComponentKey<?> type : this.keys()) {
                Object component = type.getFromContainer(this);
                component.writeToNbt(componentTag);
                if (componentTag.m_128456_()) continue;
                if (componentMap == null) {
                    componentMap = new CompoundTag();
                    tag.m_128365_(NBT_KEY, (Tag)componentMap);
                }
                componentMap.m_128365_(type.getId().toString(), (Tag)componentTag);
                componentTag = new CompoundTag();
            }
        }
        return tag;
    }

    public String toString() {
        Iterator<ComponentKey<?>> i = this.keys().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            ComponentKey<?> key = i.next();
            Object value = key.getInternal(this);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

