/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core.other;

import com.teamabnormals.allurement.common.dispenser.IronIngotDispenseBehavior;
import com.teamabnormals.allurement.core.AllurementConfig;
import com.teamabnormals.allurement.core.mixin.LivingEntityAccessor;
import com.teamabnormals.allurement.core.other.AllurementDamageTypes;
import com.teamabnormals.allurement.core.other.AllurementTrackedData;
import com.teamabnormals.allurement.core.other.AllurementUtil;
import com.teamabnormals.allurement.core.other.tags.AllurementBlockTags;
import com.teamabnormals.allurement.core.registry.AllurementEnchantments;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="allurement")
public class AllurementEvents {
    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)AllurementEnchantments.SHOCKWAVE.get()), (ItemStack)entity.m_6844_(EquipmentSlot.FEET));
        MobEffectInstance effectInstance = entity.m_21124_(MobEffects.f_19603_);
        float f = effectInstance == null ? 0.0f : (float)(effectInstance.m_19564_() + 1);
        int damage = Mth.m_14167_((float)((event.getDistance() - 3.0f - f) * event.getDamageMultiplier()));
        if (level > 0 && damage > 0) {
            for (LivingEntity target : world.m_45976_(LivingEntity.class, entity.m_20191_().m_82377_((double)level, 0.0, (double)level))) {
                if (entity == target) continue;
                target.m_6469_(AllurementDamageTypes.shockwave(world, (Entity)entity, (Entity)entity), (float)damage);
            }
            if (((Boolean)AllurementConfig.COMMON.shockwaveTramplesFarmland.get()).booleanValue()) {
                Stream affectedBlocks = BlockPos.m_121921_((AABB)entity.m_20191_().m_82377_((double)level, 0.0, (double)level).m_82386_(0.0, -1.0, 0.0));
                affectedBlocks.forEach(pos -> {
                    BlockState state = world.m_8055_(pos);
                    if (state.m_204336_(AllurementBlockTags.TRAMPLED_BY_SHOCKWAVE) && !world.f_46443_ && ForgeHooks.onFarmlandTrample((Level)world, (BlockPos)pos, (BlockState)Blocks.f_50493_.m_49966_(), (float)event.getDistance(), (Entity)entity)) {
                        FarmBlock.m_269406_((Entity)entity, (BlockState)state, (Level)world, (BlockPos)pos);
                    }
                });
            }
            if (world instanceof ServerLevel) {
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 200, (double)level, 0.5, (double)level, 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBreak(PlayerEvent.BreakSpeed event) {
        int baneOfArthropodsLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44979_, (ItemStack)event.getEntity().m_21205_());
        if (((Boolean)AllurementConfig.COMMON.baneOfArthropodsBreaksCobwebsFaster.get()).booleanValue() && event.getState().m_204336_(AllurementBlockTags.MINEABLE_WITH_BANE_OF_ARTHROPODS) && baneOfArthropodsLevel > 0) {
            event.setNewSpeed(event.getOriginalSpeed() + 5.0f * (float)baneOfArthropodsLevel * (float)baneOfArthropodsLevel);
        }
    }

    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (event.getEntity() instanceof LivingEntity && ((Boolean)AllurementConfig.COMMON.featherFallingPreventsTrampling.get()).booleanValue() && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44967_, (ItemStack)((LivingEntity)event.getEntity()).m_6844_(EquipmentSlot.FEET)) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().m_7639_();
        IDataManager manager = (IDataManager)entity;
        if (source instanceof LivingEntity) {
            IDataManager attackManager;
            float absorbedDamage;
            Map.Entry entry;
            LivingEntity attacker = (LivingEntity)source;
            int count = AllurementUtil.getTotalEnchantmentLevel((Enchantment)AllurementEnchantments.VENGEANCE.get(), entity, EquipmentSlot.Type.ARMOR);
            if (count > 0) {
                manager.setValue(AllurementTrackedData.ABSORBED_DAMAGE, (Object)Float.valueOf(event.getAmount() * (float)count * ((Double)AllurementConfig.COMMON.vengeanceDamageFactor.get()).floatValue()));
            }
            if ((entry = EnchantmentHelper.m_44906_((Enchantment)((Enchantment)AllurementEnchantments.VENGEANCE.get()), (LivingEntity)attacker)) != null && (absorbedDamage = ((Float)(attackManager = (IDataManager)attacker).getValue(AllurementTrackedData.ABSORBED_DAMAGE)).floatValue()) > 0.0f) {
                event.setAmount(event.getAmount() + absorbedDamage);
                attackManager.setValue(AllurementTrackedData.ABSORBED_DAMAGE, (Object)Float.valueOf(0.0f));
                ((ItemStack)entry.getValue()).m_41622_(2, attacker, livingEntity -> livingEntity.m_21166_((EquipmentSlot)entry.getKey()));
            }
        }
        if (((Boolean)AllurementConfig.COMMON.soulSpeedHurtsMore.get()).booleanValue() && event.getEntity() != null && EnchantmentHelper.m_44942_((LivingEntity)entity) && ((LivingEntityAccessor)entity).isSoulSpeedBlock()) {
            event.setAmount(event.getAmount() * ((Double)AllurementConfig.COMMON.soulSpeedDamageFactor.get()).floatValue());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(slot);
            int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)AllurementEnchantments.REFORMING.get()), (ItemStack)stack);
            if (stack.m_41619_() || !stack.m_41768_() || level <= 0 || world.m_46467_() % (long)((Integer)AllurementConfig.COMMON.reformingTickRate.get()).intValue() != 0L) continue;
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    @SubscribeEvent
    public static void onExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getEntity() instanceof EnderDragon && ((Boolean)AllurementConfig.COMMON.adjustEnderDragonExperienceDrop.get()).booleanValue()) {
            int amount = event.getOriginalExperience();
            int shouldDrop = (Integer)AllurementConfig.COMMON.enderDragonExperienceDrop.get();
            int shouldDropRespawn = (Integer)AllurementConfig.COMMON.respawnedEnderDragonExperienceDrop.get();
            if (amount == 960) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)shouldDrop * 0.08f)));
            } else if (amount == 2400) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)shouldDrop * 0.2f)));
            } else if (amount == 40) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)shouldDropRespawn * 0.08f)));
            } else if (amount == 100) {
                event.setDroppedExperience(Mth.m_14143_((float)((float)shouldDropRespawn * 0.2f)));
            }
        }
    }

    @SubscribeEvent
    public static void onArrowNock(ArrowNockEvent event) {
        Player player = event.getEntity();
        ItemStack bow = event.getBow();
        if (!((Boolean)AllurementConfig.COMMON.infinityRequiresArrows.get()).booleanValue() && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)bow) > 0 && player.m_6298_(bow).m_41619_()) {
            player.m_6672_(event.getHand());
            event.setAction(InteractionResultHolder.m_19096_((Object)bow));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (((Boolean)AllurementConfig.COMMON.anvilIngotRepairing.get()).booleanValue() && stack.m_150930_(Items.f_42416_) && IronIngotDispenseBehavior.canBeRepaired(state) && player.m_36341_()) {
            if (state.m_60713_(Blocks.f_50323_)) {
                IronIngotDispenseBehavior.repairAnvil(Blocks.f_50322_, level, pos);
            } else if (state.m_60713_(Blocks.f_50324_)) {
                IronIngotDispenseBehavior.repairAnvil(Blocks.f_50323_, level, pos);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
        }
    }
}

