/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core.data.client;

import com.teamabnormals.allurement.core.registry.AllurementEnchantments;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class AllurementLanguageProvider
extends LanguageProvider {
    public AllurementLanguageProvider(PackOutput output) {
        super(output, "allurement", "en_us");
    }

    protected void addTranslations() {
        this.addDesc((Enchantment)AllurementEnchantments.ALLEVIATING.get(), "Heals the user upon collection of experience");
        this.addDesc((Enchantment)AllurementEnchantments.LAUNCH.get(), "Launches the target upwards instead of away");
        this.addDesc((Enchantment)AllurementEnchantments.OBEDIENCE.get(), "Prevents horses from roaming");
        this.addDesc((Enchantment)AllurementEnchantments.REELING.get(), "Pulls targets towards the user upon arrow impact");
        this.addDesc((Enchantment)AllurementEnchantments.REFORMING.get(), "Repairs the durability of items very slowly over time when in use");
        this.addDesc((Enchantment)AllurementEnchantments.SHOCKWAVE.get(), "Creates a shockwave when taking fall damage that damages nearby entities");
        this.addDesc((Enchantment)AllurementEnchantments.VENGEANCE.get(), "Stores some incoming damage and applies it to the user's next attack");
        this.addDesc((Enchantment)AllurementEnchantments.SPREAD_OF_AILMENTS.get(), "Applies the user's active effects to their arrows");
        this.addCurse((Enchantment)AllurementEnchantments.ASCENSION_CURSE.get(), "Causes the cursed item to float upwards when dropped");
        this.addCurse((Enchantment)AllurementEnchantments.FLEETING_CURSE.get(), "Causes nearby entities to repel the cursed item when dropped");
        this.addDamageSource("shockwave", "%1$s was stomped");
        this.addDamageSource("shockwave.player", "%1$s was stomped by %2$s");
        this.addDamageSource("shockwave.player.item", "%1$s was stomped by %2$s using %3$s");
    }

    private void addDesc(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, this.format(name));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    private void addCurse(Enchantment enchantment, String description) {
        String name = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).m_135815_();
        this.add(enchantment, "Curse of " + this.format(name.replace("_curse", "")));
        this.add(enchantment.m_44704_() + ".desc", description);
    }

    private void addDamageSource(String suffix, String value) {
        this.add("death.attack.allurement." + suffix, value);
    }

    private String format(String path) {
        return WordUtils.capitalizeFully((String)path.replace("_", " ")).replace("Of ", "of ");
    }
}

