/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.allurement.core.AllurementConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HorseArmorLootModifier
extends LootModifier {
    public static final Supplier<Codec<HorseArmorLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> HorseArmorLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HorseArmorLootModifier::new)));

    public HorseArmorLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)AllurementConfig.COMMON.enchantableHorseArmor.get()).booleanValue() && ((Boolean)AllurementConfig.COMMON.enchantedHorseArmorGenerates.get()).booleanValue() && !((List)AllurementConfig.COMMON.unenchantedHorseArmorLootTables.get()).contains(context.getQueriedLootTableId().toString())) {
            RandomSource random = context.m_230907_();
            for (ItemStack stack : generatedLoot) {
                if (!(stack.m_41720_() instanceof HorseArmorItem)) continue;
                EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)UniformGenerator.m_165780_((float)20.0f, (float)39.0f).m_142683_(context), (boolean)true);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

