/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.kaleido.lib.quiltconfig.impl.util;

import folk.sisby.kaleido.lib.quiltconfig.api.exceptions.TrackedValueException;
import folk.sisby.kaleido.lib.quiltconfig.api.values.CompoundConfigValue;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ConfigSerializableObject;

public final class ConfigUtils {
    private static final Class<?>[] VALID_VALUE_CLASSES = new Class[]{Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, String.class};

    public static void assertValueType(Object object) {
        if (object == null) {
            throw new TrackedValueException("Cannot create value with null default value");
        }
        if (!ConfigUtils.isValidValue(object)) {
            throw new TrackedValueException("Cannot create value of type '" + object.getClass() + "'");
        }
    }

    public static boolean isValidValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ConfigSerializableObject) {
            return true;
        }
        if (object instanceof CompoundConfigValue) {
            while (object instanceof CompoundConfigValue) {
                object = ((CompoundConfigValue)object).getDefaultValue();
            }
            return ConfigUtils.isValidValue(object);
        }
        return ConfigUtils.isValidValueClass(object.getClass());
    }

    public static boolean isValidValueClass(Class<?> valueClass) {
        if (valueClass.isEnum()) {
            return true;
        }
        for (Class<?> clazz : VALID_VALUE_CLASSES) {
            if (clazz != valueClass) continue;
            return true;
        }
        return false;
    }
}

