/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.additionalentityattributes.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.additionalentityattributes.Support;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected Player f_20888_;

    @Inject(method={"createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void additionalEntityAttributes$addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(AdditionalEntityAttributes.WATER_SPEED);
        ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(AdditionalEntityAttributes.LAVA_SPEED);
        ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(AdditionalEntityAttributes.LUNG_CAPACITY);
        ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(AdditionalEntityAttributes.JUMP_HEIGHT);
        ((AttributeSupplier.Builder)info.getReturnValue()).m_22266_(AdditionalEntityAttributes.MAGIC_PROTECTION);
    }

    @ModifyArg(method={"travel(Lnet/minecraft/util/math/Vec3d;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V", ordinal=0))
    public float additionalEntityAttributes$waterSpeed(float original) {
        AttributeInstance waterSpeed = ((LivingEntity)this).m_21051_(AdditionalEntityAttributes.WATER_SPEED);
        if (waterSpeed == null) {
            return original;
        }
        if (waterSpeed.m_22115_() != (double)original) {
            waterSpeed.m_22100_((double)original);
        }
        return (float)waterSpeed.m_22135_();
    }

    @ModifyExpressionValue(method={"swimUpward"}, at={@At(value="CONSTANT", args={"doubleValue=0.03999999910593033D"})})
    public double additionalEntityAttributes$modifyUpwardSwimming(double original, TagKey<Fluid> fluid) {
        if (fluid == FluidTags.f_13131_) {
            AttributeInstance waterSpeed = ((LivingEntity)this).m_21051_(AdditionalEntityAttributes.WATER_SPEED);
            if (waterSpeed == null) {
                return original;
            }
            if (waterSpeed.m_22115_() != original) {
                waterSpeed.m_22100_(original);
            }
            return waterSpeed.m_22135_();
        }
        return original;
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="CONSTANT", args={"doubleValue=0.5D"}, ordinal=0), @At(value="CONSTANT", args={"doubleValue=0.5D"}, ordinal=1), @At(value="CONSTANT", args={"doubleValue=0.5D"}, ordinal=2)})
    private double additionalEntityAttributes$increasedLavaSpeed(double original) {
        AttributeInstance lavaSpeed = ((LivingEntity)this).m_21051_(AdditionalEntityAttributes.LAVA_SPEED);
        if (lavaSpeed == null) {
            return original;
        }
        if (lavaSpeed.m_22115_() != original) {
            lavaSpeed.m_22100_(original);
        }
        return lavaSpeed.m_22135_();
    }

    @ModifyArg(method={"dropXp()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    protected int additionalEntityAttributes$modifyExperience(int originalXP) {
        if (this.f_20888_ == null) {
            return originalXP;
        }
        return (int)((float)originalXP * Support.getExperienceMod(this.f_20888_));
    }

    @ModifyVariable(method={"modifyAppliedDamage"}, at=@At(value="LOAD", ordinal=4), argsOnly=true)
    private float additionalEntityAttributes$reduceMagicDamage(float damage, DamageSource source) {
        AttributeInstance magicProt = ((LivingEntity)this).m_21051_(AdditionalEntityAttributes.MAGIC_PROTECTION);
        if (magicProt == null) {
            return damage;
        }
        if (source.m_269533_(DamageTypeTags.f_268731_) && magicProt.m_22135_() > 0.0) {
            damage = (float)Math.max((double)damage - magicProt.m_22135_(), 0.0);
        }
        return damage;
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    public float additionalEntityAttributes$modifyJumpVelocity(float original) {
        AttributeInstance instance = ((LivingEntity)this).m_21051_(AdditionalEntityAttributes.JUMP_HEIGHT);
        if (instance != null) {
            float totalAmount = original;
            for (AttributeModifier modifier : instance.m_22122_()) {
                float amount = (float)modifier.m_22218_();
                if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    totalAmount += amount;
                    continue;
                }
                totalAmount *= amount + 1.0f;
            }
            if ((LivingEntity)this instanceof Player) {
                totalAmount = original + (totalAmount - original) / 2.0f;
            }
            original = totalAmount;
        }
        return original;
    }
}

