/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.item;

import com.ninni.species.client.renderer.item.SpeciesItemRenderers;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class RicoshieldItem
extends ShieldItem {
    public RicoshieldItem(Item.Properties p_43089_) {
        super(p_43089_);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (stack.m_41783_().m_128441_("StoredDamage") && stack.m_41783_().m_128457_("StoredDamage") > 0.0f) {
            this.damageTargets(stack, entity.m_9236_(), stack.m_41783_().m_128457_("StoredDamage"), entity);
        }
        super.onStopUsing(stack, entity, count);
    }

    private void damageTargets(ItemStack stack, Level level, float amount, LivingEntity player) {
        List list = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(4.0), EntitySelector.f_20406_);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SMALL_KINETIC_ENERGY.get()), player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.01, player.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
        }
        level.m_245803_((Entity)player, player.m_20183_(), (SoundEvent)SpeciesSoundEvents.RICOSHIELD_ATTACK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        for (LivingEntity target : list) {
            TamableAnimal tamableAnimal;
            if (target == player || target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_269323_() == player) continue;
            Vec3 enemyPos = target.m_20182_().m_82546_(player.m_20182_());
            Vec3 normalizedDirection = enemyPos.m_82541_();
            double knockbackXZ = 0.75 * (1.0 - target.m_21133_(Attributes.f_22278_));
            double knockbackY = 0.15 * (1.0 - target.m_21133_(Attributes.f_22278_));
            target.m_5997_(normalizedDirection.m_7096_() * knockbackXZ, normalizedDirection.m_7098_() * knockbackY, normalizedDirection.m_7094_() * knockbackXZ);
            double distanceFromEnemy = target.m_20182_().m_82554_(player.m_20182_());
            float scalingFactor = distanceFromEnemy <= 1.0 ? 1.0f : (distanceFromEnemy <= 2.0 ? 0.8f : (distanceFromEnemy <= 3.0 ? 0.65f : 0.5f));
            target.m_6469_(this.kinetic(target, player), amount *= scalingFactor);
            player.m_7327_((Entity)target);
        }
        if (player instanceof Player) {
            Player player1 = (Player)player;
            player1.m_36335_().m_41524_((Item)this, (int)(stack.m_41784_().m_128457_("StoredDamage") / 4.0f) * 20);
        }
        stack.m_41784_().m_128350_("StoredDamage", 0.0f);
    }

    public DamageSource kinetic(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return livingEntity2.m_269291_().m_268998_(SpeciesDamageTypes.KINETIC, (Entity)livingEntity, (Entity)livingEntity2);
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_((Item)SpeciesItems.BROKEN_LINKS.get());
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237113_((String)""));
        list.add((Component)Component.m_237115_((String)"item.species.ricoshield.desc.blocking").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"item.species.ricoshield.desc.damage").m_130938_(style -> style.m_178520_(14816327))));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public SpeciesItemRenderers getCustomRenderer() {
                return SpeciesItemRenderers.instance;
            }
        });
    }
}

