/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.item;

import com.ninni.species.mixin_util.AbstractArrowAccess;
import com.ninni.species.registry.SpeciesEnchantments;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrankbowItem
extends ProjectileWeaponItem
implements Vanishable {
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SHOTS_FIRED = "Speed";
    public static final String TAG_COOLDOWN = "Cooldown";
    public static final String TAG_USING = "IsUsing";

    public CrankbowItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(865));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TAG_ITEMS)) {
            CompoundTag tag = stack.m_41783_();
            tag.m_128473_(TAG_SHOTS_FIRED);
            tag.m_128473_(TAG_COOLDOWN);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int time) {
        int cooldown;
        if (stack.m_41773_() >= stack.m_41776_()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5810_();
            }
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_COOLDOWN) && (cooldown = tag.m_128451_(TAG_COOLDOWN)) > 0) {
            tag.m_128405_(TAG_COOLDOWN, cooldown - 1);
        }
        if (tag.m_128441_(TAG_ITEMS)) {
            if (!tag.m_128441_(TAG_COOLDOWN)) {
                if (stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.QUICK_CRANK.get()) > 0) {
                    entity.m_216990_((SoundEvent)SpeciesSoundEvents.CRANKBOW_PULL_QUICK.get());
                } else {
                    entity.m_216990_((SoundEvent)SpeciesSoundEvents.CRANKBOW_PULL.get());
                }
                tag.m_128405_(TAG_COOLDOWN, CrankbowItem.getShootingCooldown(stack));
                tag.m_128405_(TAG_SHOTS_FIRED, 0);
            } else if (tag.m_128451_(TAG_COOLDOWN) == 0) {
                if (stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.QUICK_CRANK.get()) > 0) {
                    entity.m_216990_((SoundEvent)SpeciesSoundEvents.CRANKBOW_PULL_QUICK.get());
                } else {
                    entity.m_216990_((SoundEvent)SpeciesSoundEvents.CRANKBOW_PULL.get());
                }
                this.shoot(level, entity, entity.m_7655_(), stack);
                tag.m_128405_(TAG_COOLDOWN, CrankbowItem.getShootingCooldown(stack));
                int shotsFired = tag.m_128451_(TAG_SHOTS_FIRED);
                if (shotsFired < 40) {
                    tag.m_128405_(TAG_SHOTS_FIRED, shotsFired + 1);
                }
            }
            if (!level.f_46443_) {
                stack.m_41784_().m_128379_(TAG_USING, true);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            tag.m_128473_(TAG_SHOTS_FIRED);
            tag.m_128473_(TAG_COOLDOWN);
            player.m_5810_();
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(TAG_COOLDOWN);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (tag.m_128441_(TAG_SHOTS_FIRED)) {
                int shots = tag.m_128451_(TAG_SHOTS_FIRED);
                player.m_36335_().m_41524_((Item)this, shots * 8);
                if (shots > 7) {
                    livingEntity.m_216990_((SoundEvent)SpeciesSoundEvents.CRANKBOW_STOP.get());
                }
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < shots / 2; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BEWEREAGER_SLOW.get()), livingEntity.m_20185_() + livingEntity.m_217043_().m_188583_() * 0.5, livingEntity.m_20227_(1.0) + (double)livingEntity.m_217043_().m_188501_(), livingEntity.m_20189_() + livingEntity.m_217043_().m_188583_() * 0.5, 1, 0.3, 0.3, 0.3, 1.0);
                    }
                }
                tag.m_128473_(TAG_SHOTS_FIRED);
                stack.m_41749_(TAG_USING);
            }
        }
    }

    private boolean shoot(Level level, LivingEntity entity, InteractionHand hand, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_ITEMS) && tag.m_128441_(TAG_SHOTS_FIRED)) {
            ListTag items = tag.m_128437_(TAG_ITEMS, 10);
            if (items.isEmpty()) {
                return false;
            }
            ItemStack arrowStack = ItemStack.m_41712_((CompoundTag)items.m_128728_(0));
            int shotsFired = tag.m_128451_(TAG_SHOTS_FIRED);
            float v = (float)shotsFired / 20.0f;
            float velocity = v + 1.15f;
            if (shotsFired % 5 == 0 && shotsFired != 0 && shotsFired <= 30) {
                entity.m_5496_((SoundEvent)SpeciesSoundEvents.CRANKBOW_SPEED.get(), 0.5f, v + 0.5f);
            }
            float spread = (2.0f + (float)(CrankbowItem.getMaxSpeed(stack) - CrankbowItem.getShootingCooldown(stack)) / (float)CrankbowItem.getMaxSpeed(stack)) / 2.0f;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int i = 0;
                while ((float)i < spread * 10.0f) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BEWEREAGER_SPEED.get()), entity.m_20208_(0.35), entity.m_20227_(0.35) + (double)entity.m_217043_().m_188501_(), entity.m_20262_(0.35), 1, 0.3, 0.3, 0.3, 1.0);
                    ++i;
                }
            }
            if (stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.SCATTERSHOT.get()) > 0) {
                if (shotsFired <= 10) {
                    float z = v * -15.0f + 10.0f;
                    CrankbowItem.shootProjectile(level, entity, hand, stack, arrowStack, 1.0f, velocity, 1.0f, z, true);
                    CrankbowItem.shootProjectile(level, entity, hand, stack, arrowStack, 1.0f, velocity, 1.0f, -z, true);
                }
                if (shotsFired <= 5) {
                    float z = v * -40.0f + 20.0f;
                    CrankbowItem.shootProjectile(level, entity, hand, stack, arrowStack, 1.0f, velocity, 1.0f, z, true);
                    CrankbowItem.shootProjectile(level, entity, hand, stack, arrowStack, 1.0f, velocity, 1.0f, -z, true);
                }
            }
            CrankbowItem.shootProjectile(level, entity, hand, stack, arrowStack, 1.0f, velocity, 1.0f, 0.0f, false);
            return true;
        }
        return false;
    }

    public static int getShootingCooldown(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_SHOTS_FIRED)) {
            int shots = tag.m_128451_(TAG_SHOTS_FIRED);
            int level = stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.QUICK_CRANK.get());
            int i = level == 0 ? 3 : Math.max(1, 4 - level);
            int cooldown = CrankbowItem.getMinSpeed(stack);
            cooldown = shots == 0 ? CrankbowItem.getMinSpeed(stack) : (shots <= 1 ? (cooldown -= i) : (shots <= 5 ? (cooldown -= 2 * i) : (shots <= 10 ? (cooldown -= 5 * i) : (shots <= 20 ? (cooldown -= 10 * i) : (shots <= 30 ? (cooldown -= 20 * i) : (cooldown -= 30 * i))))));
            return Math.max(CrankbowItem.getMaxSpeed(stack), Math.min(40, cooldown));
        }
        return CrankbowItem.getMinSpeed(stack);
    }

    public static int getMaxSpeed(ItemStack stack) {
        return switch (stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.QUICK_CRANK.get())) {
            case 1, 2 -> 6;
            case 3 -> 5;
            default -> 7;
        };
    }

    public static int getMinSpeed(ItemStack stack) {
        return switch (stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.QUICK_CRANK.get())) {
            case 1 -> 25;
            case 2 -> 20;
            case 3 -> 15;
            default -> 30;
        };
    }

    public static int getMaxWeight(ItemStack stack) {
        return 128 + stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.CAPACITY.get()) * 64;
    }

    public int m_6615_() {
        return 15;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    private static void shootProjectile(Level level, LivingEntity livingEntity, InteractionHand hand, ItemStack stack, ItemStack stack1, float pitch, float x, float y, float z, boolean fromScattershot) {
        if (!level.f_46443_) {
            ArrowItem arrowitem = (ArrowItem)(stack1.m_41720_() instanceof ArrowItem ? stack1.m_41720_() : Items.f_42412_);
            AbstractArrow abstractarrow = arrowitem.m_6394_(level, stack1, livingEntity);
            if (abstractarrow instanceof AbstractArrowAccess) {
                AbstractArrowAccess access = (AbstractArrowAccess)abstractarrow;
                access.setTgnoreImmunityFrame(true);
            }
            Vec3 vec31 = livingEntity.m_20289_(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(z * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            Vec3 vec3 = livingEntity.m_20252_(1.0f);
            Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
            abstractarrow.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), x, y);
            if (livingEntity instanceof Player) {
                boolean flag1;
                Player player = (Player)livingEntity;
                boolean bl = flag1 = player.m_150110_().f_35937_ || arrowitem.isInfinite(stack1, stack, player) || fromScattershot;
                if (flag1 || player.m_150110_().f_35937_ && (stack1.m_150930_(Items.f_42737_) || stack1.m_150930_(Items.f_42738_))) {
                    abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                if (!flag1 && !player.m_150110_().f_35937_) {
                    int i;
                    int sparingLevel = stack.getEnchantmentLevel((Enchantment)SpeciesEnchantments.SPARING.get());
                    int n = sparingLevel == 1 ? 10 : (i = sparingLevel == 2 ? 5 : 3);
                    if (sparingLevel > 0 && level.f_46441_.m_188503_(i) == 0) {
                        abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)SpeciesSoundEvents.CRANKBOW_SHOOT_SPARING.get(), SoundSource.PLAYERS, 1.0f, pitch);
                    } else {
                        CrankbowItem.removeOneItem(stack);
                        level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)SpeciesSoundEvents.CRANKBOW_SHOOT.get(), SoundSource.PLAYERS, 1.0f, pitch);
                    }
                } else if (!fromScattershot) {
                    level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)SpeciesSoundEvents.CRANKBOW_SHOOT.get(), SoundSource.PLAYERS, 1.0f, pitch);
                }
            }
            stack.m_41622_(1, livingEntity, livingEntity1 -> livingEntity1.m_21190_(hand));
            level.m_7967_((Entity)abstractarrow);
        }
    }

    public boolean m_142207_(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        if (p_150733_.m_41613_() == 1 && p_150735_ == ClickAction.SECONDARY) {
            ItemStack itemstack = p_150734_.m_7993_();
            if (itemstack.m_41619_()) {
                this.playRemoveOneSound((Entity)p_150736_);
                CrankbowItem.removeOne(p_150733_).ifPresent(p_150740_ -> CrankbowItem.add(p_150733_, p_150734_.m_150659_(p_150740_)));
            } else if (itemstack.m_41720_().m_142095_() && this.m_6437_().test(itemstack)) {
                int i = CrankbowItem.getMaxWeight(p_150733_) - CrankbowItem.getContentWeight(p_150733_);
                int j = CrankbowItem.add(p_150733_, p_150734_.m_150647_(itemstack.m_41613_(), i, p_150736_));
                if (j > 0) {
                    this.playInsertSound((Entity)p_150736_);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack p_150742_, ItemStack added, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150742_.m_41613_() != 1) {
            return false;
        }
        if (p_150745_ == ClickAction.SECONDARY && p_150744_.m_150651_(p_150746_)) {
            int i;
            if (added.m_41619_()) {
                CrankbowItem.removeOne(p_150742_).ifPresent(p_186347_ -> {
                    this.playRemoveOneSound((Entity)p_150746_);
                    p_150747_.m_142104_(p_186347_);
                });
            } else if (this.m_6437_().test(added) && (i = CrankbowItem.add(p_150742_, added)) > 0) {
                this.playInsertSound((Entity)p_150746_);
                added.m_41774_(i);
            }
            return true;
        }
        return false;
    }

    public static int add(ItemStack stack, ItemStack stack1) {
        if (!stack1.m_41619_() && stack1.m_41720_().m_142095_()) {
            CompoundTag compoundtag = stack.m_41784_();
            if (!compoundtag.m_128441_(TAG_ITEMS)) {
                compoundtag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int i = CrankbowItem.getContentWeight(stack);
            int k = Math.min(stack1.m_41613_(), CrankbowItem.getMaxWeight(stack) - i);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = CrankbowItem.getMatchingItem(stack1, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
                if (itemstack.m_41613_() + k > 64) {
                    int i2 = itemstack.m_41613_() + k;
                    itemstack.m_41764_(64);
                    itemstack.m_41739_(compoundtag1);
                    listtag.remove((Object)compoundtag1);
                    listtag.add(0, (Tag)compoundtag1);
                    ItemStack itemstack1 = stack1.m_255036_(k);
                    CompoundTag compoundtag2 = new CompoundTag();
                    itemstack1.m_41764_(i2 - 64);
                    itemstack1.m_41739_(compoundtag2);
                    listtag.add(0, (Tag)compoundtag2);
                } else {
                    itemstack.m_41769_(k);
                    itemstack.m_41739_(compoundtag1);
                    listtag.remove((Object)compoundtag1);
                    listtag.add(0, (Tag)compoundtag1);
                }
            } else {
                ItemStack itemstack1 = stack1.m_255036_(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.m_41739_(compoundtag2);
                listtag.add(0, (Tag)compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack stack, ListTag tags) {
        Optional<Object> var10000;
        if (stack.m_150930_(Items.f_151058_)) {
            var10000 = Optional.empty();
        } else {
            Stream<Object> var2 = tags.stream();
            Objects.requireNonNull(CompoundTag.class);
            var2 = var2.filter(CompoundTag.class::isInstance);
            Objects.requireNonNull(CompoundTag.class);
            var10000 = var2.map(CompoundTag.class::cast).filter(itemStack -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)((CompoundTag)itemStack)), (ItemStack)stack)).findFirst();
        }
        return var10000;
    }

    public static int getContentWeight(ItemStack itemStack2) {
        return CrankbowItem.getContents(itemStack2).mapToInt(ItemStack::m_41613_).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41784_();
        if (!compoundtag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundtag1 = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            itemStack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static Optional<ItemStack> removeOneItem(ItemStack itemStack) {
        ListTag itemList;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(TAG_ITEMS) && !(itemList = compoundTag.m_128437_(TAG_ITEMS, 10)).isEmpty()) {
            CompoundTag itemTag = itemList.m_128728_(0);
            ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)itemTag);
            ItemStack itemStack3 = itemStack2.m_255036_(itemStack2.m_41613_() - 1);
            CompoundTag itemTag3 = new CompoundTag();
            itemStack3.m_41739_(itemTag3);
            itemList.set(0, (Tag)itemTag3);
            if (itemStack2.m_41613_() == 1) {
                ItemStack itemStack1 = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(1));
                if (itemStack1.m_41619_()) {
                    compoundTag.m_128473_(TAG_ITEMS);
                }
                itemList.remove(0);
                return Optional.empty();
            }
            return Optional.of(itemStack3);
        }
        return Optional.empty();
    }

    private static Stream<ItemStack> getContents(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        return listTag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, CrankbowItem.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_((SoundEvent)SpeciesSoundEvents.CRANKBOW_REMOVE_ARROW.get(), 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_((SoundEvent)SpeciesSoundEvents.CRANKBOW_LOAD_ARROW.get(), 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        CrankbowItem.getContents(itemStack).forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new BundleTooltip(nonNullList, CrankbowItem.getContentWeight(itemStack)));
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.species.crankbow.fullness", (Object[])new Object[]{CrankbowItem.getContentWeight(itemStack), CrankbowItem.getMaxWeight(itemStack)}).m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237115_((String)"item.species.crankbow.desc").m_130948_(Style.f_131099_.m_178520_(7484744)));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_41720_() instanceof ArrowItem;
    }

    public boolean m_6832_(ItemStack stack, ItemStack stack1) {
        return stack1.m_150930_((Item)SpeciesItems.WEREFANG.get());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

