/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.util.CustomDeathParticles;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Spectre
extends Monster
implements OwnableEntity,
CustomDeathParticles,
VariantHolder<Type> {
    public static final EntityDataAccessor<Boolean> FROM_SWORD = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> DATA_TYPE_ID = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNERUUID_ID = SynchedEntityData.m_135353_(Spectre.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public final AnimationState poofAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    public int poofTimer;
    public int spawnTimer;
    public int attackTimer;
    public int dashTimer;
    public int timeLeftToLive;
    public int flyingSoundCooldown;

    public Spectre(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        if (levelAccessor instanceof ServerLevel) {
            if (this.getVariant() == Type.HULKING_SPECTRE) {
                this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(10.0);
                this.m_21051_(Attributes.f_22282_).m_22100_(4.0);
                this.m_21051_(Attributes.f_22278_).m_22100_(0.5);
            }
            if (this.getVariant() == Type.JOUSTING_SPECTRE) {
                this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
            }
            this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22135_());
        }
        return super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, livingEntity -> !this.isFromSword()));
        this.f_21346_.m_25352_(0, (Goal)new OwnerHurtByTargetGoal());
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Spectre.class}));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 0, true, false, Turtle.f_30122_));
        this.f_21345_.m_25352_(0, (Goal)new SpectreMeleeAttackGoal(this.getVariant() == Type.HULKING_SPECTRE ? 0.45 : 0.55, true));
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal(this, 0.5, 10.0f, 4.0f));
        this.f_21345_.m_25352_(5, (Goal)new DashTowardsTargetGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SpectreRandomLookAroundGoalGoal());
        this.f_21345_.m_25352_(6, (Goal)new SpectreWanderAroundGoal());
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22280_, (double)0.23f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.attackTimer == 0 && this.m_20089_() == SpeciesPose.ATTACK.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.dashTimer > 0) {
            --this.dashTimer;
        }
        if (this.dashTimer == 0 && this.m_20089_() == SpeciesPose.DASH.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.poofTimer > 0) {
            --this.poofTimer;
        }
        if (this.poofTimer == 0 && this.m_20089_() == Pose.DYING) {
            this.poofAnimationState.m_216973_();
        }
        if (this.spawnTimer > 0) {
            --this.spawnTimer;
        }
        if (this.attackTimer == 0 && this.m_20089_() == SpeciesPose.SPAWNING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.dashTimer == 0 && this.m_20089_() == SpeciesPose.DASH.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.timeLeftToLive > 0) {
            --this.timeLeftToLive;
        }
        if (this.timeLeftToLive == 0 && this.f_19797_ % 20 == 0 && this.isFromSword()) {
            this.m_6469_(this.m_269291_().m_269425_(), 4.0f);
        }
        if (!this.m_20096_()) {
            if (this.flyingSoundCooldown > 0) {
                --this.flyingSoundCooldown;
            }
            if (this.flyingSoundCooldown == 0) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_FLY.get(), 0.15f, 1.0f);
                this.flyingSoundCooldown = 60 + this.f_19796_.m_188503_(40);
            }
        }
    }

    public static void spawnSpectre(ServerLevel serverLevel, @Nullable Player player, BlockPos pos, Type type, boolean fromSword) {
        Spectre spectre = new Spectre((EntityType<? extends Monster>)((EntityType)SpeciesEntities.SPECTRE.get()), (Level)serverLevel);
        spectre.m_6034_((double)pos.m_123341_() + 0.5 + spectre.f_19796_.m_188583_() * 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5 + spectre.f_19796_.m_188583_() * 0.5);
        if (player != null) {
            if (fromSword) {
                spectre.m_21051_(Attributes.f_22280_).m_22125_(new AttributeModifier("From sword speed bonus", 0.1, AttributeModifier.Operation.ADDITION));
                spectre.setFromSword(true);
                spectre.setOwnerUUID(player.m_20148_());
                spectre.timeLeftToLive = 900;
                if (player.m_21205_().m_41788_()) {
                    spectre.m_6593_((Component)Component.m_237110_((String)"item.species.spectralibur.summon", (Object[])new Object[]{player.m_21205_().m_41786_().getString()}).m_130948_(Style.f_131099_.m_178520_(4502737)));
                }
                if (player.m_21214_() != null && player.m_21214_().m_6084_()) {
                    spectre.m_6710_(player.m_21214_());
                }
            } else if (!player.m_7500_() && !player.m_5833_()) {
                spectre.m_21563_().m_148051_((Entity)player);
                spectre.m_6710_((LivingEntity)player);
            }
        }
        spectre.setVariant(type);
        spectre.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
        spectre.m_20124_(SpeciesPose.SPAWNING.get());
        serverLevel.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRE_SPAWN.get(), spectre.m_5720_(), 1.0f, 1.0f);
        serverLevel.m_7967_((Entity)spectre);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Player player;
        Entity entity;
        if (this.isFromSword() && this.m_269323_() != null && (entity = damageSource.m_7639_()) instanceof Player && (player = (Player)entity).m_7306_((Entity)this.m_269323_())) {
            return player.m_36341_() && super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_20919_ == 1) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_DEATH.get(), 1.0f, 1.0f);
        }
        if (!this.m_213877_() && this.f_20919_ < 20) {
            this.m_246865_(new Vec3(0.0, (double)0.01f, 0.0));
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)SpeciesParticles.SPECTRE_SMOKE.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void makeDeathParticles() {
        for (int i = 0; i < 10; ++i) {
            double d3 = this.f_19796_.m_188583_() * 0.2;
            double d4 = this.f_19796_.m_188583_() * 0.2;
            this.m_9236_().m_7106_((ParticleOptions)SpeciesParticles.BROKEN_LINK.get(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), d3, 0.0, d4);
        }
        this.m_9236_().m_7106_((ParticleOptions)SpeciesParticles.SPECTRE_POP.get(), this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    public boolean m_7327_(Entity entity) {
        this.m_20124_(SpeciesPose.ATTACK.get());
        if (entity instanceof Player) {
            ItemStack stack;
            Player player = (Player)entity;
            ItemStack itemStack = stack = player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_;
            if (!stack.m_41619_() && stack.m_41720_() instanceof ShieldItem) {
                player.m_36335_().m_41524_(stack.m_41720_(), switch (this.getVariant()) {
                    case Type.JOUSTING_SPECTRE -> 100;
                    case Type.HULKING_SPECTRE -> 200;
                    default -> 0;
                });
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)this, (byte)29);
                return true;
            }
        }
        if (this.getVariant() == Type.SPECTRE) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_ATTACK.get(), 1.0f, 1.0f);
        }
        if (this.getVariant() == Type.JOUSTING_SPECTRE) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_JOUSTING_ATTACK.get(), 1.0f, 1.0f);
        }
        if (this.getVariant() == Type.HULKING_SPECTRE) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_HULKING_ATTACK.get(), 1.0f, 1.0f);
            boolean hurt = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
            float f1 = (float)this.m_21133_(Attributes.f_22282_);
            if (hurt && f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, 0.4, 0.0));
            }
            return hurt;
        }
        return super.m_7327_(entity);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.STANDING) {
                this.attackAnimationState.m_216973_();
            } else if (this.m_20089_() == SpeciesPose.ATTACK.get()) {
                this.attackTimer = 15;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.DASH.get()) {
                this.dashTimer = 40;
                this.dashAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.SPAWNING.get()) {
                this.spawnTimer = 25;
                this.spawnAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.DYING) {
                this.poofTimer = 40;
                this.poofAnimationState.m_216977_(this.f_19797_);
                this.dashAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    protected PathNavigation m_6037_(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.m_26440_(true);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), vec3);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    protected void m_7355_(BlockPos p_218364_, BlockState p_218365_) {
    }

    protected void m_7840_(double p_218316_, boolean p_218317_, BlockState p_218318_, BlockPos p_218319_) {
    }

    public SoundSource m_5720_() {
        return this.isFromSword() ? SoundSource.PLAYERS : SoundSource.HOSTILE;
    }

    protected boolean m_6125_() {
        return !this.isFromSword();
    }

    public boolean m_6935_(Player player) {
        return !this.isFromSword();
    }

    public boolean m_6149_() {
        return false;
    }

    protected boolean m_8028_() {
        return !this.isFromSword();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_SWORD, (Object)false);
        this.f_19804_.m_135372_(OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)"spectre");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromSword", this.isFromSword());
        compoundTag.m_128359_("Type", this.getVariant().m_7912_());
        compoundTag.m_128405_("TimeLeftToLive", this.timeLeftToLive);
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("Owner")) {
            compoundTag.m_128342_("Owner");
        } else {
            OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)compoundTag.m_128461_("Owner"));
        }
        this.timeLeftToLive = compoundTag.m_128451_("TimeLeftToLive");
        this.setVariant(Type.byName(compoundTag.m_128461_("Type")));
        this.setFromSword(compoundTag.m_128471_("FromSword"));
    }

    public Type getVariant() {
        return Type.byName((String)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(Type type) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)type.m_7912_());
    }

    public boolean isFromSword() {
        return (Boolean)this.f_19804_.m_135370_(FROM_SWORD);
    }

    public void setFromSword(boolean fromSword) {
        this.f_19804_.m_135381_(FROM_SWORD, (Object)fromSword);
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }

    public boolean m_7307_(Entity entity) {
        if (this.isFromSword()) {
            LivingEntity livingentity = this.m_269323_();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.getVariant() == Type.JOUSTING_SPECTRE ? SoundEvents.f_271165_ : (SoundEvent)SpeciesSoundEvents.SPECTRE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SpeciesSoundEvents.SPECTRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_271165_;
    }

    public static enum Type implements StringRepresentable
    {
        SPECTRE("spectre"),
        JOUSTING_SPECTRE("jousting_spectre"),
        HULKING_SPECTRE("hulking_spectre");

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type byName(String name) {
            return (Type)CODEC.m_262792_(name, (Enum)SPECTRE);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }

    public class OwnerHurtByTargetGoal
    extends TargetGoal {
        private final Spectre spectre;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public OwnerHurtByTargetGoal() {
            super((Mob)Spectre.this, false);
            this.spectre = Spectre.this;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.spectre.isFromSword() && this.spectre.m_21805_() != null) {
                LivingEntity livingentity = this.spectre.m_269323_();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurtBy);
            LivingEntity livingentity = this.spectre.m_269323_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public class OwnerHurtTargetGoal
    extends TargetGoal {
        private final Spectre spectre;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public OwnerHurtTargetGoal() {
            super((Mob)Spectre.this, false);
            this.spectre = Spectre.this;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.spectre.isFromSword() && this.spectre.m_21805_() != null) {
                LivingEntity livingentity = this.spectre.m_269323_();
                if (livingentity == null) {
                    return false;
                }
                this.ownerLastHurt = livingentity.m_21214_();
                int i = livingentity.m_21215_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurt);
            LivingEntity livingentity = this.spectre.m_269323_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }

    class SpectreMeleeAttackGoal
    extends MeleeAttackGoal {
        public SpectreMeleeAttackGoal(double p_25553_, boolean p_25554_) {
            super((PathfinderMob)Spectre.this, p_25553_, p_25554_);
        }

        public boolean m_8036_() {
            if (Spectre.this.getVariant() == Type.JOUSTING_SPECTRE) {
                return false;
            }
            return super.m_8036_();
        }
    }

    public class FollowOwnerGoal
    extends Goal {
        private final Spectre spectre;
        private LivingEntity owner;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;

        public FollowOwnerGoal(Spectre spectre, double speed, float startDistance, float stopDistance) {
            this.spectre = spectre;
            this.speedModifier = speed;
            this.navigation = spectre.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.spectre.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (this.spectre.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(this.spectre.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return this.spectre.m_20159_() || this.spectre.m_21523_();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
        }

        public void m_8037_() {
            this.spectre.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.spectre.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_5624_((Entity)this.owner, Spectre.this.getVariant() == Type.HULKING_SPECTRE ? this.speedModifier * 0.7 : this.speedModifier);
            }
        }
    }

    public static class DashTowardsTargetGoal
    extends Goal {
        protected final Spectre mob;
        private int timer;
        private boolean attacked;

        public DashTowardsTargetGoal(Spectre mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            if (this.mob.m_5448_() == null || this.mob.isFromSword() && this.mob.m_5448_().m_7306_((Entity)this.mob.m_269323_()) || this.mob.getVariant() != Type.JOUSTING_SPECTRE) {
                return false;
            }
            return !(this.mob.m_5448_() instanceof Player) || !this.mob.m_5448_().m_5833_() && !((Player)this.mob.m_5448_()).m_7500_();
        }

        public boolean m_8045_() {
            if (this.mob.m_5448_() == null || this.timer <= 0 || this.mob.isFromSword() && this.mob.m_5448_().m_7306_((Entity)this.mob.m_269323_())) {
                return false;
            }
            return !(this.mob.m_5448_() instanceof Player) || !this.mob.m_5448_().m_5833_() && !((Player)this.mob.m_5448_()).m_7500_();
        }

        public void m_8056_() {
            this.timer = 40;
            this.attacked = false;
            this.mob.m_216990_((SoundEvent)SpeciesSoundEvents.SPECTRE_SPOT.get());
        }

        public void m_8037_() {
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.mob.m_5448_() != null) {
                if (this.timer > 20) {
                    this.mob.m_246865_(new Vec3(0.0, (double)0.01f, 0.0));
                }
                double d0 = this.mob.m_262793_(this.mob.m_5448_());
                this.checkAndPerformAttack(this.mob.m_5448_(), d0);
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), (float)this.mob.m_8085_(), (float)this.mob.m_8132_());
                this.mob.m_5618_(this.mob.m_6080_());
                this.mob.m_146922_(this.mob.m_6080_());
            }
            if (this.timer == 30 && !this.attacked) {
                this.mob.m_20124_(SpeciesPose.DASH.get());
            }
            if (this.attacked && this.mob.dashAnimationState.m_216984_()) {
                this.mob.dashAnimationState.m_216973_();
            }
            if (this.timer == 20 && !this.attacked && this.mob.m_5448_() != null) {
                this.mob.m_5496_((SoundEvent)SpeciesSoundEvents.SPECTRE_DASH.get(), 1.5f, 1.0f);
                Vec3 direction = new Vec3(this.mob.m_5448_().m_20185_() - this.mob.m_20185_(), this.mob.m_5448_().m_20186_() - this.mob.m_20186_(), this.mob.m_5448_().m_20189_() - this.mob.m_20189_()).m_82541_().m_82490_(1.5);
                this.mob.m_20256_(new Vec3(direction.f_82479_, direction.f_82480_, direction.f_82481_));
                this.mob.m_21573_().m_26573_();
            }
        }

        protected void checkAndPerformAttack(LivingEntity livingEntity, double distance) {
            double reach = this.getAttackReachSqr(livingEntity);
            if (distance <= reach && !this.attacked) {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)livingEntity);
                if (livingEntity.m_20202_() != null) {
                    livingEntity.m_6038_();
                    livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(new Vec3(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_), 0.0)));
                }
                this.attacked = true;
            }
        }

        protected double getAttackReachSqr(LivingEntity target) {
            return this.mob.m_20205_() * 3.0f * this.mob.m_20205_() * 3.0f + target.m_20205_();
        }

        public void m_8041_() {
            this.mob.m_20124_(Pose.STANDING);
        }
    }

    class SpectreRandomLookAroundGoalGoal
    extends RandomLookAroundGoal {
        SpectreRandomLookAroundGoalGoal() {
            super((Mob)Spectre.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Spectre.this.m_5448_() == null;
        }
    }

    class SpectreWanderAroundGoal
    extends Goal {
        SpectreWanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Spectre.this.getVariant() == Type.JOUSTING_SPECTRE) {
                return false;
            }
            return Spectre.this.f_21344_.m_26571_() && Spectre.this.f_19796_.m_188503_(10) == 0 && Spectre.this.m_5448_() == null;
        }

        public boolean m_8045_() {
            if (Spectre.this.getVariant() == Type.JOUSTING_SPECTRE) {
                return false;
            }
            return Spectre.this.f_21344_.m_26572_() && Spectre.this.m_5448_() == null;
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                Spectre.this.f_21344_.m_26536_(Spectre.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3d), 1), Spectre.this.getVariant() == Type.HULKING_SPECTRE ? 0.2 : 0.5);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2 = Spectre.this.m_20252_(0.0f);
            Vec3 vec3d3 = HoverRandomPos.m_148465_((PathfinderMob)Spectre.this, (int)12, (int)5, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Spectre.this, (int)12, (int)2, (int)-2, (double)vec3d2.f_82479_, (double)vec3d2.f_82481_, (double)1.5707963705062866);
        }
    }
}

