/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_3.Hanger;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LeafHanger
extends Hanger {
    public static final EntityDataAccessor<Boolean> IS_PULLING_TARGET = SynchedEntityData.m_135353_(LeafHanger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockState> BAIT_BLOCK_STATE = SynchedEntityData.m_135353_(LeafHanger.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);

    public LeafHanger(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, true));
        this.f_21345_.m_25352_(0, (Goal)new PullTowardsMouthGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BaitTargetingGoal(this, entity -> {
            Axolotl axolotl;
            boolean flag;
            boolean bl = flag = (entity.m_6095_().m_204039_(SpeciesTags.LEAF_HANGER_PREY) || entity instanceof Player) && this.m_6779_((LivingEntity)entity) && entity.m_6084_() && !entity.m_5833_();
            if (entity instanceof Axolotl && (axolotl = (Axolotl)entity).m_149175_()) {
                return false;
            }
            return flag;
        }));
        this.f_21345_.m_25352_(1, (Goal)new CastBaitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FindUnderWaterSpotGoal(this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 4.0f, 1.0, 1.25, livingEntity -> !this.m_20072_() && !(livingEntity instanceof LeafHanger)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        Holder holder = serverLevelAccessor.m_204166_(this.m_20183_());
        if (holder.m_203656_(SpeciesTags.LEAF_HANGER_HAS_DRIPLEAF)) {
            this.setBaitBlockState(Blocks.f_152545_.m_49966_());
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, spawnType, groupData, tag);
    }

    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.f_19796_.m_188503_(50) == 0) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20208_(1.0), this.m_20186_() + (double)this.getCurrentTonguePos().y, this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.f_19796_.m_188501_() < 0.3f && this.isPullingTarget()) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123774_, this.m_20208_(1.5), this.m_20186_() + (double)this.getTongueOffset(), this.m_20262_(1.5), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void unstuckTarget() {
        Axolotl axolotl;
        LivingEntity livingEntity;
        super.unstuckTarget();
        if ((double)this.getTargetPos().y < this.m_20186_() - 3.0 && this.isTongueOut() || (livingEntity = this.m_5448_()) instanceof Axolotl && (axolotl = (Axolotl)livingEntity).m_149175_()) {
            this.deactivateTongue();
            this.m_6710_(null);
            this.setCantAttackTicks(40);
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isTongueOut()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        }
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.01f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(1.0).m_82520_(0.0, -0.2, 0.0));
        } else {
            super.m_7023_(vec3);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PULLING_TARGET, (Object)false);
        this.f_19804_.m_135372_(BAIT_BLOCK_STATE, (Object)Blocks.f_50196_.m_49966_());
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("IsPullingTarget", this.isPullingTarget());
        compoundTag.m_128365_("BaitBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.getBaitBlockState()));
        super.m_7380_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        this.setPullingTarget(compoundTag.m_128471_("IsPullingTarget"));
        this.setBaitBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("BaitBlockState")));
        super.m_7378_(compoundTag);
    }

    public boolean isPullingTarget() {
        return (Boolean)this.f_19804_.m_135370_(IS_PULLING_TARGET);
    }

    public void setPullingTarget(boolean bl) {
        this.f_19804_.m_135381_(IS_PULLING_TARGET, (Object)bl);
    }

    public BlockState getBaitBlockState() {
        return (BlockState)this.f_19804_.m_135370_(BAIT_BLOCK_STATE);
    }

    public void setBaitBlockState(BlockState state) {
        this.f_19804_.m_135381_(BAIT_BLOCK_STATE, (Object)state);
    }

    public boolean m_6914_(LevelReader p_30348_) {
        return p_30348_.m_45784_((Entity)this);
    }

    public static boolean canSpawn(EntityType<? extends Hanger> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_) && world.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_) && world.m_46791_() != Difficulty.PEACEFUL && pos.m_123342_() < world.m_5736_() - 5;
    }

    @Override
    public boolean m_7327_(Entity target) {
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_ATTACK.get(), this.m_5720_(), 1.0f, 1.0f);
        return super.m_7327_(target);
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return this.m_5448_() != null && this.isTongueOut() ? (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_IDLE_PULLING.get() : (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.LEAF_HANGER_STEP.get(), 0.15f, this.m_6100_());
    }

    public static class PullTowardsMouthGoal
    extends Goal {
        private final LeafHanger leafHanger;

        public PullTowardsMouthGoal(LeafHanger leafHanger) {
            this.leafHanger = leafHanger;
        }

        public boolean m_8036_() {
            return this.leafHanger.m_5842_() && this.leafHanger.m_5448_() != null && (!this.leafHanger.m_5448_().m_20159_() || this.leafHanger.m_5448_().m_20202_() instanceof Boat) && this.leafHanger.getCantAttackTicks() == 0 && this.leafHanger.m_5448_().m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.leafHanger.setPullingTarget(true);
        }

        public void m_8037_() {
            if (!this.leafHanger.m_9236_().f_46443_) {
                LivingEntity target = this.leafHanger.m_5448_();
                if (target.m_20182_().f_82480_ > this.leafHanger.m_20182_().f_82480_ - 3.0) {
                    Vec3 diff = this.leafHanger.m_20182_().m_82520_(0.0, (double)this.leafHanger.getTongueOffset(), 0.0).m_82546_(target.m_20182_());
                    double diffY = Math.abs(diff.f_82480_);
                    diff = diff.m_82542_(0.15, 0.0, 0.15).m_82520_(0.0, diffY * -0.02 - 0.01, 0.0);
                    target.m_20256_(target.m_20184_().m_82549_(diff));
                    Entity entity = target.m_20202_();
                    if (entity instanceof Boat) {
                        Boat boat = (Boat)entity;
                        this.leafHanger.m_6710_(null);
                        this.leafHanger.setCantAttackTicks(200);
                        boat.m_20256_(boat.m_20184_().m_82520_(0.0, -0.7, 0.0));
                        boat.m_20153_();
                        this.m_8041_();
                    }
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        player.f_19864_ = true;
                    }
                }
                if (this.leafHanger.f_19797_ % 10 == 0) {
                    this.leafHanger.m_9236_().m_6263_(null, this.leafHanger.m_20185_(), this.leafHanger.m_20186_(), this.leafHanger.m_20189_(), (SoundEvent)SpeciesSoundEvents.HANGER_PULL.get(), this.leafHanger.m_5720_(), 1.0f, 1.0f);
                }
                Vector3f visualTarget = target.m_20191_().m_82399_().m_252839_();
                this.leafHanger.setTargetPos(visualTarget);
                this.leafHanger.setTongueTarget(visualTarget);
            }
        }

        public boolean m_8045_() {
            return this.leafHanger.m_5842_() && this.leafHanger.m_5448_() != null && (!this.leafHanger.m_5448_().m_20159_() || this.leafHanger.m_5448_().m_20202_() instanceof Boat) && this.leafHanger.getCantAttackTicks() == 0 && this.leafHanger.m_5448_().m_6084_();
        }

        public void m_8041_() {
            this.leafHanger.setPullingTarget(false);
            this.leafHanger.deactivateTongue();
        }
    }

    public static class BaitTargetingGoal
    extends Goal {
        private final LeafHanger leafHanger;
        private final Predicate<LivingEntity> predicate;

        public BaitTargetingGoal(LeafHanger leafHanger, Predicate<LivingEntity> predicate) {
            this.leafHanger = leafHanger;
            this.predicate = predicate;
        }

        public boolean m_8036_() {
            if (!this.leafHanger.m_5842_() || !this.leafHanger.isTongueOut() || this.leafHanger.m_5448_() != null || this.leafHanger.getCantAttackTicks() > 0) {
                return false;
            }
            BlockPos lilyPadPos = BlockPos.m_274446_((Position)new Vec3(this.leafHanger.getTargetPos()));
            AABB box = new AABB((double)lilyPadPos.m_123341_(), (double)(lilyPadPos.m_123342_() - 1), (double)lilyPadPos.m_123343_(), (double)(lilyPadPos.m_123341_() + 1), (double)(lilyPadPos.m_123342_() + 2), (double)(lilyPadPos.m_123343_() + 1));
            List potentialTargets = this.leafHanger.m_9236_().m_6443_(LivingEntity.class, box, this.predicate);
            if (!potentialTargets.isEmpty()) {
                this.leafHanger.m_6710_((LivingEntity)potentialTargets.get(0));
                ((LivingEntity)potentialTargets.get(0)).m_6469_(this.leafHanger.m_269291_().m_269333_((LivingEntity)this.leafHanger), 0.0f);
                this.leafHanger.m_9236_().m_5594_(null, ((LivingEntity)potentialTargets.get(0)).m_20183_(), (SoundEvent)SpeciesSoundEvents.LEAF_HANGER_CATCH.get(), this.leafHanger.m_5720_(), 2.0f, 1.0f);
                Object e = potentialTargets.get(0);
                if (e instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)e;
                    Advancement hangerAdvancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation("species", "species/v3/fall_for_hanger"));
                    if (hangerAdvancement != null) {
                        if (serverPlayer.m_8960_().m_135996_(hangerAdvancement).m_8193_()) {
                            SpeciesCriterion.FALL_FOR_HANGER_TWICE.trigger(serverPlayer);
                        } else {
                            SpeciesCriterion.FALL_FOR_HANGER.trigger(serverPlayer);
                        }
                    }
                }
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.leafHanger.m_5448_() != null && this.leafHanger.m_5448_().m_6084_() && this.leafHanger.getCantAttackTicks() == 0;
        }

        public void m_8041_() {
            this.leafHanger.m_6710_(null);
        }
    }

    public static class CastBaitGoal
    extends Goal {
        private final LeafHanger leafHanger;

        public CastBaitGoal(LeafHanger leafHanger) {
            this.leafHanger = leafHanger;
        }

        public boolean m_8036_() {
            return !this.leafHanger.isTongueOut() && this.leafHanger.m_5842_() && this.leafHanger.m_21573_().m_26571_() && this.leafHanger.getCantAttackTicks() == 0;
        }

        public void m_8037_() {
            Vec3 mobCenter = this.leafHanger.m_20182_().m_82520_(0.0, (double)this.leafHanger.getTongueOffset(), 0.0);
            BlockPos currentPos = BlockPos.m_274446_((Position)mobCenter);
            while (this.leafHanger.m_9236_().m_8055_(currentPos).m_60819_().m_192917_((Fluid)Fluids.f_76193_) && this.leafHanger.m_9236_().m_8055_(currentPos).m_60819_().m_76170_()) {
                currentPos = currentPos.m_7495_();
            }
            BlockPos searchPos = currentPos.m_7494_();
            while (this.leafHanger.m_9236_().m_8055_(searchPos).m_60819_().m_192917_((Fluid)Fluids.f_76193_) && this.leafHanger.m_9236_().m_8055_(searchPos).m_60819_().m_76170_()) {
                searchPos = searchPos.m_7494_();
            }
            Vec3 target = Vec3.m_82539_((Vec3i)searchPos);
            if (mobCenter.m_82554_(target) < 40.0 && this.leafHanger.m_9236_().m_8055_(searchPos).m_60795_()) {
                this.leafHanger.m_216990_((SoundEvent)SpeciesSoundEvents.LEAF_HANGER_SHOOT.get());
                this.leafHanger.activateTongue(target.m_252839_());
            } else {
                this.m_8041_();
            }
        }
    }

    public static class FindUnderWaterSpotGoal
    extends Goal {
        private final LeafHanger leafHanger;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public FindUnderWaterSpotGoal(LeafHanger leafHanger, double speed) {
            this.leafHanger = leafHanger;
            this.speedModifier = speed;
            this.level = leafHanger.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.leafHanger.isTongueOut() || !this.leafHanger.m_21573_().m_26571_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.leafHanger.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.leafHanger.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @javax.annotation.Nullable
        private Vec3 getWaterPos() {
            RandomSource random = this.leafHanger.m_217043_();
            BlockPos origin = this.leafHanger.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = origin.m_7918_(random.m_188503_(20) - 10, 2 - random.m_188503_(20), random.m_188503_(20) - 10);
                if (!this.level.m_46805_(pos) || pos.m_123342_() <= this.level.m_141937_() || pos.m_123342_() >= this.level.m_151558_() || !this.level.m_8055_(pos).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)pos);
            }
            return null;
        }
    }
}

