/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.ninni.species.server.entity.mob.update_2.Treeper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class TreeperCanopy
extends PartEntity<Treeper> {
    public final Treeper parent;
    public final String name;
    private final EntityDimensions size;
    private float xOffset;
    private float yOffset;
    private float zOffset;

    public TreeperCanopy(Treeper parent, String head, float width, float height, float xOffset, float yOffset, float zOffset) {
        super((Entity)parent);
        this.size = EntityDimensions.m_20395_((float)width, (float)height);
        this.m_6210_();
        this.parent = parent;
        this.name = head;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public float getxOffset() {
        return this.xOffset;
    }

    public float getyOffset() {
        return this.yOffset;
    }

    public float getzOffset() {
        return this.zOffset;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.parent.isPlanted() && this.tryPlaceBlock(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return this.parent.m_6096_(player, hand);
    }

    private boolean tryPlaceBlock(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 end = eyePos.m_82549_(lookVec.m_82490_(5.0));
        AABB aabb = this.m_20191_();
        Vec3 hitVec = aabb.m_82371_(eyePos, end).orElse(null);
        if (hitVec == null) {
            return false;
        }
        Direction face = this.getHitDirection(hitVec, aabb);
        if (face == null) {
            return false;
        }
        BlockPos pos = BlockPos.m_274446_((Position)hitVec);
        if (face != Direction.NORTH && face != Direction.UP && face != Direction.WEST) {
            pos = pos.m_121945_(face);
        }
        Level level = player.m_9236_();
        if (!player.m_36204_(pos, face, stack)) {
            return false;
        }
        if (!level.m_7966_(player, pos)) {
            return false;
        }
        if (!level.m_8055_(pos).m_247087_()) {
            return false;
        }
        BlockPlaceContext context = new BlockPlaceContext(player, hand, stack, new BlockHitResult(hitVec, face, pos, false));
        if (!level.f_46443_ && (result = blockItem.m_40576_(context)).m_19077_()) {
            BlockState placed = level.m_8055_(pos);
            SoundType sound = placed.m_60827_();
            level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            return true;
        }
        return false;
    }

    private Direction getHitDirection(Vec3 hit, AABB box) {
        double dx = hit.f_82479_ - box.f_82288_;
        double dy = hit.f_82480_ - box.f_82289_;
        double dz = hit.f_82481_ - box.f_82290_;
        double maxDx = box.f_82291_ - box.f_82288_;
        double maxDy = box.f_82292_ - box.f_82289_;
        double maxDz = box.f_82293_ - box.f_82290_;
        double epsilon = 1.0E-4;
        if (Math.abs(dx) < epsilon) {
            return Direction.WEST;
        }
        if (Math.abs(dx - maxDx) < epsilon) {
            return Direction.EAST;
        }
        if (Math.abs(dy) < epsilon) {
            return Direction.DOWN;
        }
        if (Math.abs(dy - maxDy) < epsilon) {
            return Direction.UP;
        }
        if (Math.abs(dz) < epsilon) {
            return Direction.NORTH;
        }
        if (Math.abs(dz - maxDz) < epsilon) {
            return Direction.SOUTH;
        }
        return null;
    }

    public boolean m_5829_() {
        return this.parent.isPlanted();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.parent.m_142340_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !this.m_6673_(source) && this.parent.m_6469_(source, amount);
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.parent == entity;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        throw new UnsupportedOperationException();
    }

    public boolean m_142391_() {
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }
}

