/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Mammutilation
extends PathfinderMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState coughAnimationState = new AnimationState();
    public final AnimationState howlAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> COUGH_COOLDOWN = SynchedEntityData.m_135353_(Mammutilation.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ICHOR_COUNT = SynchedEntityData.m_135353_(Mammutilation.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ICHOR_COOLDOWN = SynchedEntityData.m_135353_(Mammutilation.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Map<Block, SoundEvent> SOUNDS_BY_EGG = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Blocks.f_50578_, SoundEvents.f_12534_);
        map.put(Blocks.f_276643_, SoundEvents.f_276434_);
        map.put((Block)SpeciesBlocks.WRAPTOR_EGG.get(), (SoundEvent)SpeciesSoundEvents.WRAPTOR_EGG_CRACK.get());
        map.put((Block)SpeciesBlocks.PETRIFIED_EGG.get(), (SoundEvent)SpeciesSoundEvents.PETRIFIED_EGG_CRACK.get());
        map.put((Block)SpeciesBlocks.SPRINGLING_EGG.get(), (SoundEvent)SpeciesSoundEvents.SPRINGLING_EGG_CRACK.get());
    });
    private int coughTimer;
    private int hatchCooldown;
    private int howlCooldown;
    private int howlTimer;
    private int idleAnimationTimeout = 0;

    public Mammutilation(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.75));
        this.f_21345_.m_25352_(2, (Goal)new CoughGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HowlAtMoonGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22281_, 0.0);
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.hatchCooldown > 0) {
                --this.hatchCooldown;
            }
            if (this.coughTimer > 0) {
                --this.coughTimer;
                if (this.coughTimer == 15) {
                    BlockPos blockPos2 = this.m_20183_();
                    float angle = (float)Math.PI / 180 * this.f_20883_;
                    double headX = 3.0f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
                    double headZ = 3.0f * this.m_6134_() * Mth.m_14089_((float)angle);
                    Vec3 shootingVec = this.m_20154_().m_82490_(2.0).m_82542_(0.5, 1.0, 0.5);
                    double d = shootingVec.m_7096_();
                    double e = shootingVec.m_7098_();
                    double g = shootingVec.m_7094_();
                    double h = Math.sqrt(d * d + g * g);
                    this.m_246865_(new Vec3(0.0, 0.25, 0.0));
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.ICHOR.get()), (double)blockPos2.m_123341_() + headX, (double)((float)blockPos2.m_123342_() + this.m_20192_()), (double)blockPos2.m_123343_() + headZ, 20, d, e + h * 0.5, g, 8.0);
                    }
                    this.m_246865_(this.m_20154_().m_82490_(2.0).m_82542_(-0.5, 0.0, -0.5));
                }
            } else if (this.m_20089_() == SpeciesPose.COUGHING.get()) {
                this.m_20124_(Pose.STANDING);
            }
            if (this.howlCooldown > 0) {
                --this.howlCooldown;
            }
            if (this.getIchorCooldown() > 0) {
                this.setIchorCooldown(this.getIchorCooldown() - 1);
            }
            if (this.howlTimer > 0) {
                --this.howlTimer;
            } else if (this.m_20089_() == SpeciesPose.HOWLING.get()) {
                this.m_20124_(Pose.STANDING);
            }
            if (this.hatchCooldown == 0) {
                this.getAllEggPositions().stream().filter(blockPos -> this.m_9236_().m_8055_(blockPos).m_61138_((Property)BlockStateProperties.f_61416_)).forEach(this::handleEggHatching);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(Items.f_42590_) && !this.m_6162_() && this.getIchorCount() > 0 && this.getIchorCooldown() == 0) {
            player.m_5496_((SoundEvent)SpeciesSoundEvents.MAMMUTILATION_BLEED.get(), 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)SpeciesItems.ICHOR_BOTTLE.get()).m_7968_());
            this.setIchorCount(this.getIchorCount() - 1);
            this.ichorCooldown();
            player.m_21008_(interactionHand, itemStack2);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    public int m_8132_() {
        return 20;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COUGH_COOLDOWN, (Object)(600 + this.f_19796_.m_188503_(2400)));
        this.f_19804_.m_135372_(ICHOR_COUNT, (Object)5);
        this.f_19804_.m_135372_(ICHOR_COOLDOWN, (Object)0);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.hatchCooldown = compoundTag.m_128451_("HatchCooldown");
        this.howlCooldown = compoundTag.m_128451_("HowlCooldown");
        this.coughTimer = compoundTag.m_128451_("CoughTimer");
        this.setCoughCooldown(compoundTag.m_128451_("CoughCooldown"));
        this.setIchorCount(compoundTag.m_128451_("IchorCount"));
        this.setIchorCooldown(compoundTag.m_128451_("IchorCooldown"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("HatchCooldown", this.hatchCooldown);
        compoundTag.m_128405_("HowlCooldown", this.howlCooldown);
        compoundTag.m_128405_("CoughTimer", this.coughTimer);
        compoundTag.m_128405_("CoughCooldown", this.getCoughCooldown());
        compoundTag.m_128405_("IchorCount", this.getIchorCount());
        compoundTag.m_128405_("IchorCooldown", this.getIchorCooldown());
    }

    public int getIchorCount() {
        return (Integer)this.f_19804_.m_135370_(ICHOR_COUNT);
    }

    public void setIchorCount(int count) {
        this.f_19804_.m_135381_(ICHOR_COUNT, (Object)count);
    }

    public int getIchorCooldown() {
        return (Integer)this.f_19804_.m_135370_(ICHOR_COOLDOWN);
    }

    public void setIchorCooldown(int cooldown) {
        this.f_19804_.m_135381_(ICHOR_COOLDOWN, (Object)cooldown);
    }

    public void ichorCooldown() {
        this.f_19804_.m_135381_(ICHOR_COOLDOWN, (Object)20);
    }

    public int m_8100_() {
        return 200;
    }

    public int getCoughCooldown() {
        return (Integer)this.f_19804_.m_135370_(COUGH_COOLDOWN);
    }

    public void setCoughCooldown(int cooldown) {
        this.f_19804_.m_135381_(COUGH_COOLDOWN, (Object)cooldown);
    }

    public void coughCooldown() {
        this.f_19804_.m_135381_(COUGH_COOLDOWN, (Object)(600 + this.f_19796_.m_188503_(2400)));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getCoughCooldown() > 0) {
            this.setCoughCooldown(this.getCoughCooldown() - 1);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout == 0) {
            this.idleAnimationTimeout = 160;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == SpeciesPose.COUGHING.get()) {
                this.coughAnimationState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == SpeciesPose.HOWLING.get()) {
                this.howlAnimationState.m_216977_(this.f_19797_);
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    private void handleEggHatching(BlockPos blockPos) {
        BlockState blockState = this.m_9236_().m_8055_(blockPos);
        int hatch = (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61416_);
        this.m_9236_().m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61416_, (Comparable)Integer.valueOf(hatch + 1)), 2);
        if (SOUNDS_BY_EGG.containsKey(blockState.m_60734_())) {
            this.m_9236_().m_5594_(null, blockPos, SOUNDS_BY_EGG.get(blockState.m_60734_()), SoundSource.BLOCKS, 0.7f, 0.9f + this.m_217043_().m_188501_() * 0.2f);
        }
        this.m_9236_().m_46796_(3009, blockPos, 0);
        this.hatchCooldown = UniformInt.m_146622_((int)6000, (int)12000).m_214085_(this.m_217043_());
    }

    public List<BlockPos> getAllEggPositions() {
        ArrayList poses = Lists.newArrayList();
        int radius = 8;
        int yRange = radius / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -yRange; y <= yRange; ++y) {
                    BlockPos blockPos = BlockPos.m_274561_((double)(this.m_20185_() + (double)x), (double)(this.m_20186_() + (double)y), (double)(this.m_20189_() + (double)z));
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (!blockState.m_61138_((Property)BlockStateProperties.f_61416_) || (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61416_) >= 2) continue;
                    poses.add(blockPos);
                    this.handleTallEggs(blockState, blockPos, poses);
                }
            }
        }
        return poses;
    }

    private void handleTallEggs(BlockState blockState, BlockPos blockPos, List<BlockPos> poses) {
        boolean isDoubleBlockTall = blockState.m_61138_((Property)BlockStateProperties.f_61401_);
        Arrays.stream(Direction.values()).filter(direction -> direction.m_122434_() == Direction.Axis.Y).forEach(direction -> {
            boolean hasDoubleBlockInRelativeState;
            BlockState relativeState = this.m_9236_().m_8055_(blockPos.m_121945_(direction));
            DoubleBlockHalf doubleBlockHalf = direction == Direction.DOWN ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER;
            boolean bl = hasDoubleBlockInRelativeState = relativeState.m_60713_(blockState.m_60734_()) && relativeState.m_61143_((Property)BlockStateProperties.f_61401_) == doubleBlockHalf && isDoubleBlockTall;
            if (hasDoubleBlockInRelativeState) {
                poses.add(blockPos.m_121945_(direction));
            }
        });
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.hatchCooldown = UniformInt.m_146622_((int)6000, (int)12000).m_214085_(this.m_217043_());
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.MAMMUTILATION_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpeciesSoundEvents.MAMMUTILATION_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_7755_().getString().equalsIgnoreCase("mammutiful")) {
            return (SoundEvent)SpeciesSoundEvents.MAMMUTIFUL_IDLE.get();
        }
        return (SoundEvent)SpeciesSoundEvents.MAMMUTILATION_IDLE.get();
    }

    public static boolean canSpawn(EntityType<Mammutilation> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return false;
    }

    public static class CoughGoal
    extends Goal {
        protected final Mammutilation mammutilation;

        public CoughGoal(Mammutilation mammutilation) {
            this.mammutilation = mammutilation;
        }

        public void m_8056_() {
            this.mammutilation.coughCooldown();
            this.mammutilation.coughTimer = 25;
            this.mammutilation.m_20124_(SpeciesPose.COUGHING.get());
            this.mammutilation.m_5496_((SoundEvent)SpeciesSoundEvents.MAMMUTILATION_COUGH.get(), 1.0f, 1.0f);
        }

        public boolean m_8036_() {
            return this.mammutilation.getCoughCooldown() == 0 && this.mammutilation.m_20089_() != SpeciesPose.HOWLING.get();
        }
    }

    public static class HowlAtMoonGoal
    extends Goal {
        protected final Mammutilation mammutilation;

        public HowlAtMoonGoal(Mammutilation mammutilation) {
            this.mammutilation = mammutilation;
        }

        public void m_8056_() {
            if (this.mammutilation.m_7755_().getString().equalsIgnoreCase("mammutiful")) {
                this.mammutilation.m_216990_((SoundEvent)SpeciesSoundEvents.MAMMUTIFUL_HOWL.get());
            } else {
                this.mammutilation.m_216990_((SoundEvent)SpeciesSoundEvents.MAMMUTILATION_HOWL.get());
            }
            this.mammutilation.howlCooldown = 1000;
            this.mammutilation.howlTimer = 80;
            this.mammutilation.m_20124_(SpeciesPose.HOWLING.get());
            this.mammutilation.setIchorCount(5);
        }

        public boolean m_8036_() {
            return this.mammutilation.m_9236_().m_46462_() && this.mammutilation.howlCooldown == 0 && this.mammutilation.m_20089_() != SpeciesPose.COUGHING.get();
        }
    }
}

