/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.server.block.entity.CruncherPelletBlockEntity;
import com.ninni.species.server.data.CruncherPelletManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CruncherPellet
extends FallingBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private CruncherPelletManager.CruncherPelletData pelletData;

    public CruncherPellet(EntityType<? extends FallingBlockEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CruncherPellet(Level level, double d, double e, double f, BlockState blockState, CruncherPelletManager.CruncherPelletData data) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)SpeciesEntities.CRUNCHER_PELLET.get()), level);
        this.f_31946_ = blockState;
        this.f_19850_ = true;
        this.m_6034_(d, e, f);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = d;
        this.f_19855_ = e;
        this.f_19856_ = f;
        this.m_31959_(this.m_20183_());
        this.pelletData = data;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("PelletData", 10)) {
            CruncherPelletManager.CruncherPelletData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_("PelletData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setPelletData);
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.pelletData != null) {
            CruncherPelletManager.CruncherPelletData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getPelletData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("PelletData", tag));
        }
    }

    public void m_8119_() {
        if (this.m_31980_().m_60795_()) {
            this.m_146870_();
            return;
        }
        Block block = this.m_31980_().m_60734_();
        ++this.f_31942_;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            BlockHitResult blockHitResult;
            BlockPos blockPos = this.m_20183_();
            boolean bl = this.m_31980_().m_60734_() instanceof ConcretePowderBlock;
            boolean bl2 = bl && this.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_);
            double d = this.m_20184_().m_82556_();
            if (bl && d > 1.0 && (blockHitResult = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.m_9236_().m_6425_(blockHitResult.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                blockPos = blockHitResult.m_82425_();
                bl2 = true;
            }
            if (this.m_20096_() || bl2) {
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                if (!blockState.m_60713_(Blocks.f_50110_)) {
                    boolean bl5;
                    boolean bl3 = blockState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                    boolean bl4 = FallingBlock.m_53241_((BlockState)this.m_9236_().m_8055_(blockPos.m_7495_())) && (!bl || !bl2);
                    boolean bl6 = bl5 = this.m_31980_().m_60710_((LevelReader)this.m_9236_(), blockPos) && !bl4;
                    if (bl3 && bl5) {
                        if (this.m_31980_().m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockPos).m_76152_() == Fluids.f_76193_) {
                            this.f_31946_ = (BlockState)this.m_31980_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                        }
                        if (this.m_9236_().m_7731_(blockPos, this.m_31980_(), 3)) {
                            BlockEntity blockEntity;
                            this.m_216990_(SoundEvents.f_215738_);
                            BlockEntity blockEntity2 = this.m_9236_().m_7702_(blockPos);
                            if (blockEntity2 instanceof CruncherPelletBlockEntity) {
                                CruncherPelletBlockEntity cruncherPelletBlock = (CruncherPelletBlockEntity)blockEntity2;
                                cruncherPelletBlock.setPelletData(this.pelletData);
                            }
                            ((ServerLevel)this.m_9236_()).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockPos, this.m_9236_().m_8055_(blockPos)));
                            this.m_146870_();
                            if (block instanceof Fallable) {
                                Fallable fallable = (Fallable)block;
                                fallable.m_48792_(this.m_9236_(), blockPos, this.m_31980_(), blockState, (FallingBlockEntity)this);
                            }
                            if (this.f_31944_ != null && this.m_31980_().m_155947_() && (blockEntity = this.m_9236_().m_7702_(blockPos)) != null) {
                                CompoundTag compoundTag = blockEntity.m_187482_();
                                for (String string : this.f_31944_.m_128431_()) {
                                    compoundTag.m_128365_(string, this.f_31944_.m_128423_(string).m_6426_());
                                }
                                try {
                                    blockEntity.m_142466_(compoundTag);
                                }
                                catch (Exception exception) {
                                    LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                }
                                blockEntity.m_6596_();
                            }
                        } else if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_146870_();
                            this.m_9236_().m_7731_(blockPos, this.m_31980_(), 3);
                            this.m_216990_(SoundEvents.f_215738_);
                            BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                            if (blockEntity instanceof CruncherPelletBlockEntity) {
                                CruncherPelletBlockEntity cruncherPelletBlock = (CruncherPelletBlockEntity)blockEntity;
                                cruncherPelletBlock.setPelletData(this.pelletData);
                            }
                        }
                    } else {
                        this.m_146870_();
                        this.m_9236_().m_7731_(blockPos, this.m_31980_(), 3);
                        this.m_216990_(SoundEvents.f_215738_);
                        BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                        if (blockEntity instanceof CruncherPelletBlockEntity) {
                            CruncherPelletBlockEntity cruncherPelletBlock = (CruncherPelletBlockEntity)blockEntity;
                            cruncherPelletBlock.setPelletData(this.pelletData);
                        }
                    }
                }
            } else if (!(this.m_9236_().f_46443_ || (this.f_31942_ <= 100 || blockPos.m_123342_() > this.m_9236_().m_141937_() && blockPos.m_123342_() <= this.m_9236_().m_151558_()) && this.f_31942_ <= 600)) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)SpeciesBlocks.CRUNCHER_PELLET.get()).m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.0, 0.0, 0.0, 1.0);
                }
                this.m_146870_();
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    @Nullable
    public CruncherPelletManager.CruncherPelletData getPelletData() {
        return this.pelletData;
    }

    public void setPelletData(CruncherPelletManager.CruncherPelletData data) {
        this.pelletData = data;
    }
}

