/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_1;

import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.ai.goal.WraptorSwoopAtTargetGoal;
import com.ninni.species.server.entity.util.SpeciesPose;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Wraptor
extends Animal
implements Enemy,
Shearable {
    public static final EntityDataAccessor<Integer> FEATHER_STAGE = SynchedEntityData.m_135353_(Wraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_BORN_FROM_EGG = SynchedEntityData.m_135353_(Wraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Wraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String FEATHER_STAGE_KEY = "FeatherStage";
    public static final String TIME_SINCE_SHEARED_KEY = "TimeSinceSheared";
    public final AnimationState roarAnimationState = new AnimationState();
    public final AnimationState fallingAnimationState = new AnimationState();
    private int roarTime;
    private long timeSinceSheared;

    public Wraptor(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 3;
    }

    public float m_274421_() {
        return 1.0f;
    }

    public static AttributeSupplier.Builder createWraptorAttributes() {
        return Wraptor.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", serverLevelAccessor.m_213780_().m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FEATHER_STAGE, (Object)5);
        this.f_19804_.m_135372_(IS_BORN_FROM_EGG, (Object)false);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, false));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WraptorSwoopAtTargetGoal(this, 0.5f));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(1.2, false));
        this.f_21345_.m_25352_(1, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new LayGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(SpeciesTags.WRAPTOR_BREED_ITEMS), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public int getFeatherStage() {
        return (Integer)this.f_19804_.m_135370_(FEATHER_STAGE);
    }

    public void setFeatherStage(int stage) {
        this.f_19804_.m_135381_(FEATHER_STAGE, (Object)stage);
    }

    public boolean m_6220_() {
        return this.getFeatherStage() > 0;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        return mobEffectInstance.m_19544_() != MobEffects.f_19615_ && super.m_7301_(mobEffectInstance);
    }

    protected void m_8024_() {
        super.m_8024_();
        long time = this.m_9236_().m_46467_();
        int stage = this.getFeatherStage();
        if (this.m_9236_().m_6042_().m_63960_()) {
            if (stage < 5 && this.f_19796_.m_188503_((int)(time - this.timeSinceSheared)) > 3000) {
                this.timeSinceSheared = time;
                this.setFeatherStage(stage + 1);
            }
        } else if (this.m_6220_() && this.f_19796_.m_188503_(300) == 0) {
            this.setFeatherStage(stage - 1);
            this.m_5496_((SoundEvent)SpeciesSoundEvents.WRAPTOR_FEATHER_LOSS.get(), 1.0f, 1.0f);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.f_146733_ % 80 == 0 && this.m_6162_() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0 && (this.getFeatherStage() == 0 || this.m_6162_())) {
            if (this.m_20089_() != SpeciesPose.FLAPPING.get()) {
                this.m_20124_(SpeciesPose.FLAPPING.get());
            }
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_20089_() == SpeciesPose.FLAPPING.get() && this.m_20096_()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20089_() != SpeciesPose.FLAPPING.get() && this.fallingAnimationState.m_216984_()) {
            this.fallingAnimationState.m_216973_();
        }
        if (this.m_20089_() == SpeciesPose.FLAPPING.get()) {
            this.fallingAnimationState.m_216982_(this.f_19797_);
        }
        if (this.roarTime > 0) {
            --this.roarTime;
        }
        if (this.roarTime == 0 && this.m_20089_() == Pose.ROARING) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.m_9236_().f_46443_ && this.roarTime == 0 && this.roarAnimationState.m_216984_()) {
            this.roarAnimationState.m_216973_();
        }
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    public boolean m_6785_(double d) {
        return !this.m_21532_();
    }

    public boolean m_6149_() {
        return true;
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42574_) && !this.m_6162_()) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                if (this.getFeatherStage() == 0) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        SpeciesCriterion.SHEAR_WRAPTOR_COMPLETELY.trigger(serverPlayer);
                    }
                    if (!player.m_7500_() && !this.isBormFromEgg()) {
                        if (!this.m_20067_()) {
                            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpeciesSoundEvents.WRAPTOR_AGGRO.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                        }
                        this.m_20124_(Pose.ROARING);
                        this.m_6710_((LivingEntity)player);
                    }
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        InteractionResult result = super.m_6071_(player, hand);
        if (result.m_19077_()) {
            this.m_21530_();
        }
        return result;
    }

    public void m_5851_(SoundSource category) {
        int stage = this.getFeatherStage();
        if (stage == 5) {
            this.timeSinceSheared = this.m_9236_().m_46467_();
        }
        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpeciesSoundEvents.WRAPTOR_SHEAR.get(), category, 1.0f, 1.0f);
        this.setFeatherStage(stage - 1);
        int l = 2 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < l; ++i) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)Items.f_42402_, 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.ROARING) {
                this.roarAnimationState.m_216977_(this.f_19797_);
                this.roarTime = 50;
            } else if (this.m_20089_() == Pose.STANDING) {
                this.roarAnimationState.m_216973_();
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(FEATHER_STAGE_KEY, this.getFeatherStage());
        nbt.m_128356_(TIME_SINCE_SHEARED_KEY, this.timeSinceSheared);
        nbt.m_128379_("IsBornFromEgg", this.isBormFromEgg());
        nbt.m_128379_("HasEgg", this.hasEgg());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setFeatherStage(nbt.m_128451_(FEATHER_STAGE_KEY));
        this.timeSinceSheared = nbt.m_128454_(TIME_SINCE_SHEARED_KEY);
        this.setBormFromEgg(nbt.m_128471_("IsBornFromEgg"));
        this.setHasEgg(nbt.m_128471_("HasEgg"));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getFeatherStage() <= 2 || !this.m_9236_().m_6042_().m_63960_()) {
            return (SoundEvent)SpeciesSoundEvents.WRAPTOR_AGITATED.get();
        }
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.WRAPTOR_STEP.get(), 0.15f, 1.0f);
    }

    public boolean isBormFromEgg() {
        return (Boolean)this.f_19804_.m_135370_(IS_BORN_FROM_EGG);
    }

    public void setBormFromEgg(boolean bormFromEgg) {
        this.f_19804_.m_135381_(IS_BORN_FROM_EGG, (Object)bormFromEgg);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static boolean canSpawn(EntityType<Wraptor> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50692_);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(SpeciesTags.WRAPTOR_BREED_ITEMS);
    }

    public boolean m_6573_(Player player) {
        return this.isBormFromEgg();
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(double speed, boolean pauseWhenIdle) {
            super((PathfinderMob)Wraptor.this, speed, pauseWhenIdle);
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.m_25564_()) {
                this.m_25563_();
                Wraptor.this.m_7327_((Entity)target);
                Wraptor.this.m_5496_((SoundEvent)SpeciesSoundEvents.WRAPTOR_ATTACK.get(), 1.0f, 1.0f);
            }
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final Wraptor wraptor;

        MateGoal(Wraptor wraptor, double speed) {
            super((Animal)wraptor, speed);
            this.wraptor = wraptor;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.wraptor.hasEgg();
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_25114_.m_7605_((Entity)this.wraptor, (byte)18);
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.wraptor.m_20185_(), this.wraptor.m_20186_(), this.wraptor.m_20189_(), this.wraptor.m_217043_().m_188503_(7) + 1));
            }
        }

        protected void m_8026_() {
            if (this.f_25115_ != null) {
                ServerPlayer serverPlayerEntity = this.wraptor.m_27592_();
                if (serverPlayerEntity == null && this.f_25113_.m_27592_() != null) {
                    serverPlayerEntity = this.f_25113_.m_27592_();
                }
                if (serverPlayerEntity != null) {
                    serverPlayerEntity.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)this.wraptor, this.f_25113_, null);
                }
                this.wraptor.m_146762_(6000);
                this.f_25113_.m_146762_(6000);
                this.wraptor.m_27594_();
                this.f_25113_.m_27594_();
                this.wraptor.setHasEgg(true);
            }
        }
    }

    static class LayGoal
    extends MoveToBlockGoal {
        private final Wraptor wraptor;

        LayGoal(Wraptor wraptor, double speed) {
            super((PathfinderMob)wraptor, speed, 16);
            this.wraptor = wraptor;
        }

        public boolean m_8036_() {
            return this.wraptor.hasEgg() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.wraptor.hasEgg();
        }

        public void m_8041_() {
            super.m_8041_();
            Level world = this.wraptor.m_9236_();
            world.m_5594_(null, this.wraptor.m_20183_(), (SoundEvent)SpeciesSoundEvents.WRAPTOR_EGG.get(), SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.wraptor.m_20069_() && this.m_25625_() && this.wraptor.m_9236_().m_6042_().m_63960_()) {
                this.wraptor.m_9236_().m_7731_(this.f_25602_.m_7494_(), ((Block)SpeciesBlocks.WRAPTOR_EGG.get()).m_49966_(), 3);
                this.wraptor.setHasEgg(false);
                this.wraptor.m_27601_(600);
            }
        }

        protected boolean m_6465_(LevelReader world, BlockPos pos) {
            return world.m_46859_(pos.m_7494_()) && world.m_8055_(pos).m_204336_(SpeciesTags.WRAPTOR_NESTING_BLOCKS);
        }
    }
}

