/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block.entity;

import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.packet.BlockEntitySyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SpectraliburBlockEntity
extends BlockEntity
implements IForgeBlockEntity {
    public static final float BASE_INCREMENT = 0.1f;
    public float swordPosition;
    public float shaking;
    public int hitCooldown;
    public int downCooldown;
    public int decrementCoolDown;

    public SpectraliburBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpeciesBlockEntities.SPECTRALIBUR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpectraliburBlockEntity entity) {
        if (entity.swordPosition >= 1.0f) {
            ServerLevel serverLevel;
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_EXTRACT.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SPECTRALIBUR_RELEASED.get()), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SPECTRALIBUR.get()), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.25f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            }
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), new ItemStack((ItemLike)SpeciesItems.SPECTRALIBUR.get()));
            itemEntity.m_20256_(new Vec3(0.0, 0.5, 0.0));
            level.m_7967_((Entity)itemEntity);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel2 = (ServerLevel)level;
                ExperienceOrb.m_147082_((ServerLevel)serverLevel2, (Vec3)pos.m_252807_().m_82520_(0.0, 0.6, 0.0), (int)140);
            }
            return;
        }
        if (entity.hitCooldown > 0) {
            --entity.hitCooldown;
        }
        if (entity.downCooldown > 0) {
            if (entity.hitCooldown == 1) {
                SoundEvent soundEvent = entity.swordPosition <= 0.5f ? (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_CAN_BE_PULLED1.get() : (entity.swordPosition > 0.5f && entity.swordPosition <= 0.9f ? (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_CAN_BE_PULLED2.get() : (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_CAN_BE_PULLED3.get());
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundEvent, SoundSource.BLOCKS, 2.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.ASCENDING_SPECTRE_SMOKE.get()), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.1f), (double)((float)pos.m_123343_() + 0.5f), 10, level.f_46441_.m_188583_() * 0.15, 0.2, level.f_46441_.m_188583_() * 0.15, 0.0);
                }
            }
            --entity.downCooldown;
        }
        if (entity.swordPosition > 0.0f && entity.downCooldown == 0) {
            if (entity.decrementCoolDown > 0) {
                --entity.decrementCoolDown;
                return;
            }
            if (entity.decrementCoolDown == 0) {
                entity.shaking = 0.0f;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SPECTRALIBUR_INVERTED.get()), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.01f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                }
                entity.swordPosition = Math.max(0.0f, entity.swordPosition - 0.1f);
                if (entity.swordPosition == 0.0f) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_GO_IN_FULLY.get(), SoundSource.BLOCKS, 2.0f, 0.75f);
                } else {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_GO_IN.get(), SoundSource.BLOCKS, 2.0f, 0.75f + entity.swordPosition * 0.5f);
                }
                entity.decrementCoolDown = 40;
                entity.sync();
            }
        }
    }

    public void onHit(Player player) {
        if (player != null) {
            if (this.hitCooldown == 0) {
                if (!player.m_21023_(MobEffects.f_19600_) && this.swordPosition == 0.0f) {
                    this.hitCooldown = 5;
                } else {
                    boolean higherStrengthlevel = player.m_21023_(MobEffects.f_19600_) && player.m_21124_(MobEffects.f_19600_).m_19564_() > 0;
                    this.swordPosition = Math.min(1.0f, this.swordPosition + 0.1f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        SpeciesCriterion.START_SPECTRE_CHALLENGE.trigger(serverPlayer);
                    }
                    if (player.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                        this.hitCooldown = 20;
                        this.downCooldown = 60;
                    } else {
                        if ((double)this.swordPosition <= 0.2) {
                            this.hitCooldown = higherStrengthlevel ? 50 : 60;
                            int n = this.downCooldown = higherStrengthlevel ? 90 : 100;
                        }
                        if ((double)this.swordPosition > 0.2 && (double)this.swordPosition <= 0.4) {
                            this.hitCooldown = higherStrengthlevel ? 70 : 80;
                            int n = this.downCooldown = higherStrengthlevel ? 120 : 130;
                        }
                        if ((double)this.swordPosition > 0.4 && (double)this.swordPosition <= 0.8) {
                            this.hitCooldown = higherStrengthlevel ? 85 : 100;
                            int n = this.downCooldown = higherStrengthlevel ? 135 : 150;
                        }
                        if ((double)this.swordPosition > 0.8) {
                            this.hitCooldown = higherStrengthlevel ? 100 : 120;
                            this.downCooldown = higherStrengthlevel ? 200 : 220;
                        }
                    }
                }
            }
            this.shaking = player.m_9236_().m_46467_();
            this.sync();
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("SwordPosition")) {
            this.swordPosition = nbt.m_128457_("SwordPosition");
        }
        if (nbt.m_128441_("Shaking")) {
            this.shaking = nbt.m_128457_("Shaking");
        }
        if (nbt.m_128441_("HitCooldown")) {
            this.hitCooldown = nbt.m_128451_("HitCooldown");
        }
        if (nbt.m_128441_("DownCooldown")) {
            this.downCooldown = nbt.m_128451_("DownCooldown");
        }
        if (nbt.m_128441_("DecrementCooldown")) {
            this.decrementCoolDown = nbt.m_128451_("DecrementCooldown");
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("SwordPosition", this.swordPosition);
        nbt.m_128350_("Shaking", this.shaking);
        nbt.m_128405_("HitCooldown", this.hitCooldown);
        nbt.m_128405_("DownCooldown", this.downCooldown);
        nbt.m_128405_("DecrementCooldown", this.decrementCoolDown);
    }

    public void sync() {
        this.m_6596_();
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            SpeciesNetwork.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new BlockEntitySyncPacket(this.f_58858_, tag));
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public float getSwordPosition() {
        return this.swordPosition;
    }

    public boolean isOnCooldown() {
        return this.hitCooldown > 0;
    }

    public float getShaking() {
        return this.shaking;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - 2), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)(pos.m_123342_() + 2), (double)pos.m_123343_() + 1.0);
    }
}

