/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block.entity;

import com.google.common.collect.Lists;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.block.BirtDwellingBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BirtDwellingBlockEntity
extends BlockEntity
implements GameEventListener.Holder<BirtDwellingListener> {
    public static final String MIN_OCCUPATION_TICKS_KEY = "MinOccupationTicks";
    public static final String ENTITY_DATA_KEY = "EntityData";
    public static final String TICKS_IN_DWELLING_KEY = "TicksInDwelling";
    public static final String BIRTS_KEY = "Birts";
    private static final List<String> IRRELEVANT_BIRT_NBT_KEYS = Arrays.asList("Air", "Bees", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterDwellingTicks", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "DwellingPos", "HivePos", "Passengers", "Leash", "UUID");
    private final List<Birt> birts = Lists.newArrayList();
    private int day = -1;
    private final BirtDwellingListener birtDwellingListener;
    private int pacifyTicks = 0;

    public BirtDwellingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpeciesBlockEntities.BIRT_DWELLING.get(), pos, state);
        this.birtDwellingListener = new BirtDwellingListener(state, (PositionSource)new BlockPositionSource(pos));
    }

    public boolean hasNoBirts() {
        return this.birts.isEmpty();
    }

    public boolean isFullOfBirts() {
        return this.birts.size() == 3;
    }

    public void angerBirts(@Nullable Player player, BlockState state, BirtState birtState) {
        if (this.pacifyTicks > 0) {
            return;
        }
        List<Entity> list = this.tryReleaseBirt(state, birtState);
        if (player != null) {
            for (Entity entity : list) {
                if (!(entity instanceof com.ninni.species.server.entity.mob.update_1.Birt)) continue;
                com.ninni.species.server.entity.mob.update_1.Birt birt = (com.ninni.species.server.entity.mob.update_1.Birt)entity;
                if (!(player.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                birt.m_6710_((LivingEntity)player);
                birt.setCannotEnterDwellingTicks(400);
            }
        }
    }

    public static void tickLayEgg(BirtDwellingBlockEntity birtDwellingBlockEntity, Level world, BlockPos blockPos, BlockState state) {
        long day = world.m_46468_() / 24000L;
        if (birtDwellingBlockEntity.day == -1 || day != (long)birtDwellingBlockEntity.day && day == 0L) {
            birtDwellingBlockEntity.day = (int)day;
        }
        if ((Integer)state.m_61143_((Property)BirtDwellingBlock.BIRTS) > 0 && (long)birtDwellingBlockEntity.day < day) {
            ++birtDwellingBlockEntity.day;
            world.m_46597_(blockPos, (BlockState)state.m_61124_((Property)BirtDwellingBlock.EGGS, (Comparable)Integer.valueOf(Math.min(5, (Integer)state.m_61143_((Property)BirtDwellingBlock.EGGS) + (Integer)state.m_61143_((Property)BirtDwellingBlock.BIRTS)))));
        }
    }

    private List<Entity> tryReleaseBirt(BlockState state, BirtState birtState) {
        ArrayList list = Lists.newArrayList();
        this.birts.removeIf(birt -> {
            assert (this.f_58857_ != null);
            return BirtDwellingBlockEntity.releaseBirt(this.f_58857_, this.f_58858_, state, birt, list, birtState);
        });
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public void tryEnterDwelling(Entity entity) {
        this.tryEnterDwelling(entity, 0);
    }

    public void tryEnterDwelling(Entity entity, int ticksInDwelling) {
        if (this.birts.size() >= 3) {
            return;
        }
        entity.m_8127_();
        entity.m_20153_();
        CompoundTag nbtCompound = new CompoundTag();
        entity.m_20223_(nbtCompound);
        BlockPos blockPos = this.m_58899_();
        this.addBirt(nbtCompound, ticksInDwelling);
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (SoundEvent)SpeciesSoundEvents.BLOCK_BIRT_DWELLING_ENTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.f_58857_.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
        }
        entity.m_146870_();
        super.m_6596_();
    }

    public void addBirt(CompoundTag nbtCompound, int ticksInDwelling) {
        assert (this.f_58857_ != null);
        this.birts.add(new Birt(nbtCompound, ticksInDwelling, 1200));
    }

    private static boolean releaseBirt(Level world, BlockPos pos, BlockState state, Birt birt, @Nullable List<Entity> entities, BirtState birtState) {
        boolean bl;
        if (world.m_46461_() && birtState != BirtState.EMERGENCY) {
            return false;
        }
        CompoundTag nbtCompound = birt.entityData.m_6426_();
        BirtDwellingBlockEntity.removeIrrelevantNbtKeys(nbtCompound);
        nbtCompound.m_128365_("DwellingPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        Direction direction = (Direction)state.m_61143_((Property)BirtDwellingBlock.FACING);
        BlockPos blockPos = pos.m_121945_(direction);
        boolean bl2 = bl = !world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos).m_83281_();
        if (bl && birtState != BirtState.EMERGENCY) {
            return false;
        }
        Entity newBirt = EntityType.m_20645_((CompoundTag)nbtCompound, (Level)world, entity -> entity);
        if (newBirt != null) {
            if (newBirt instanceof com.ninni.species.server.entity.mob.update_1.Birt) {
                com.ninni.species.server.entity.mob.update_1.Birt birtEntity = (com.ninni.species.server.entity.mob.update_1.Birt)newBirt;
                BirtDwellingBlockEntity.ageBirt(Birt.ticksInDwelling, birtEntity);
                if (entities != null) {
                    entities.add((Entity)birtEntity);
                }
            } else {
                return false;
            }
            float f = newBirt.m_20205_();
            double d = bl ? 0.0 : 0.55 + (double)(f / 2.0f);
            double x = (double)pos.m_123341_() + 0.5 + d * (double)direction.m_122429_();
            double y = (double)pos.m_123342_() + 0.5 - (double)(newBirt.m_20206_() / 2.0f);
            double z = (double)pos.m_123343_() + 0.5 + d * (double)direction.m_122431_();
            newBirt.m_7678_(x, y, z, newBirt.m_146908_(), newBirt.m_146909_());
            world.m_5594_(null, pos, (SoundEvent)SpeciesSoundEvents.BLOCK_BIRT_DWELLING_EXIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)newBirt, (BlockState)world.m_8055_(pos)));
            return world.m_7967_(newBirt);
        }
        return false;
    }

    static void removeIrrelevantNbtKeys(CompoundTag compound) {
        for (String string : IRRELEVANT_BIRT_NBT_KEYS) {
            compound.m_128473_(string);
        }
    }

    private static void ageBirt(int ticks, com.ninni.species.server.entity.mob.update_1.Birt birt) {
        int i = birt.m_146764_();
        if (i < 0) {
            birt.m_146762_(Math.min(0, i + ticks));
        } else if (i > 0) {
            birt.m_146762_(Math.max(0, i - ticks));
        }
    }

    private static void tickBirts(Level world, BlockPos pos, BlockState state, List<Birt> birts) {
        boolean bl = false;
        Iterator<Birt> iterator = birts.iterator();
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)BirtDwellingBlock.BIRTS, (Comparable)Integer.valueOf(birts.size())));
        while (iterator.hasNext()) {
            Birt birt = iterator.next();
            if (Birt.ticksInDwelling > birt.minOccupationTicks && BirtDwellingBlockEntity.releaseBirt(world, pos, state, birt, null, BirtState.BIRT_RELEASED)) {
                bl = true;
                iterator.remove();
            }
            ++Birt.ticksInDwelling;
        }
        if (bl) {
            BirtDwellingBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, BirtDwellingBlockEntity blockEntity) {
        BirtDwellingBlockEntity.tickBirts(world, pos, state, blockEntity.birts);
        BirtDwellingBlockEntity.tickLayEgg(blockEntity, world, pos, state);
        if (blockEntity.pacifyTicks > 0) {
            --blockEntity.pacifyTicks;
        }
        if (!blockEntity.birts.isEmpty() && world.m_213780_().m_188500_() < 0.005) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = pos.m_123342_();
            double f = (double)pos.m_123343_() + 0.5;
            world.m_6263_(null, d, e, f, (SoundEvent)SpeciesSoundEvents.BLOCK_BIRT_DWELLING_WORK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.birts.clear();
        ListTag nbtList = nbt.m_128437_(BIRTS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            Birt birt = new Birt(nbtCompound.m_128469_(ENTITY_DATA_KEY), nbtCompound.m_128451_(TICKS_IN_DWELLING_KEY), nbtCompound.m_128451_(MIN_OCCUPATION_TICKS_KEY));
            this.birts.add(birt);
        }
        this.day = nbt.m_128451_("Day");
        this.pacifyTicks = nbt.m_128451_("PacifyTicks");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_(BIRTS_KEY, (Tag)this.getBirts());
        nbt.m_128405_("Day", this.day);
        nbt.m_128405_("PacifyTicks", this.pacifyTicks);
    }

    public ListTag getBirts() {
        ListTag nbtList = new ListTag();
        for (Birt birt : this.birts) {
            CompoundTag nbtCompound = birt.entityData.m_6426_();
            nbtCompound.m_128473_("UUID");
            CompoundTag nbtCompound2 = new CompoundTag();
            nbtCompound2.m_128365_(ENTITY_DATA_KEY, (Tag)nbtCompound);
            nbtCompound2.m_128405_(IRRELEVANT_BIRT_NBT_KEYS.toString(), Birt.ticksInDwelling);
            nbtCompound2.m_128405_(MIN_OCCUPATION_TICKS_KEY, birt.minOccupationTicks);
            nbtList.add((Object)nbtCompound2);
        }
        return nbtList;
    }

    public BirtDwellingListener getListener() {
        return this.birtDwellingListener;
    }

    public static class BirtDwellingListener
    implements GameEventListener {
        private final BlockState blockState;
        private final PositionSource positionSource;

        public BirtDwellingListener(BlockState blockState, PositionSource positionSource) {
            this.blockState = blockState;
            this.positionSource = positionSource;
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return 8;
        }

        public GameEventListener.DeliveryMode m_247514_() {
            return GameEventListener.DeliveryMode.BY_DISTANCE;
        }

        public boolean m_214068_(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 vec32) {
            BlockEntity blockEntity;
            Optional position = this.positionSource.m_142502_((Level)serverLevel);
            if (position.isEmpty()) {
                return false;
            }
            BlockPos blockPos = BlockPos.m_274446_((Position)((Position)position.get()));
            if (com.ninni.species.server.entity.mob.update_1.Birt.isLoudNoise(gameEvent, serverLevel, BlockPos.m_274446_((Position)vec32)) && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof BirtDwellingBlockEntity) {
                BirtDwellingBlockEntity birtDwellingBlockEntity = (BirtDwellingBlockEntity)blockEntity;
                if (birtDwellingBlockEntity.pacifyTicks == 0) {
                    birtDwellingBlockEntity.pacifyTicks = 100;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum BirtState {
        BIRT_RELEASED,
        EMERGENCY;

    }

    static class Birt {
        final CompoundTag entityData;
        static int ticksInDwelling;
        final int minOccupationTicks;

        Birt(CompoundTag entityData, int ticksInDwelling, int minOccupationTicks) {
            BirtDwellingBlockEntity.removeIrrelevantNbtKeys(entityData);
            this.entityData = entityData;
            Birt.ticksInDwelling = ticksInDwelling;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

