/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.Species;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.block.entity.SpectraliburBlockEntity;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpectraliburBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0, (double)12.0);
    private static final Map<Integer, List<Wave>> WAVES = Map.of(0, List.of(new Wave(Spectre.Type.SPECTRE, 1, false)), 1, List.of(new Wave(Spectre.Type.SPECTRE, 1, true)), 2, List.of(new Wave(Spectre.Type.JOUSTING_SPECTRE, 1, false)), 3, List.of(new Wave(Spectre.Type.JOUSTING_SPECTRE, 0, true), new Wave(Spectre.Type.SPECTRE, 1, false)), 4, List.of(new Wave(Spectre.Type.SPECTRE, 1, true), new Wave(Spectre.Type.JOUSTING_SPECTRE, 0, true)), 5, List.of(new Wave(Spectre.Type.HULKING_SPECTRE, 1, false)), 6, List.of(new Wave(Spectre.Type.HULKING_SPECTRE, 0, true), new Wave(Spectre.Type.SPECTRE, 1, true)), 7, List.of(new Wave(Spectre.Type.SPECTRE, 1, false), new Wave(Spectre.Type.JOUSTING_SPECTRE, 1, true), new Wave(Spectre.Type.HULKING_SPECTRE, 0, true)), 8, List.of(new Wave(Spectre.Type.SPECTRE, 0, true), new Wave(Spectre.Type.JOUSTING_SPECTRE, 1, true)), 9, List.of(new Wave(Spectre.Type.JOUSTING_SPECTRE, 1, true), new Wave(Spectre.Type.HULKING_SPECTRE, 1, true)));

    public SpectraliburBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpectraliburBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState p_56331_, BlockGetter p_56332_, BlockPos p_56333_, CollisionContext p_56334_) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)SpeciesBlocks.SPECTRALIBUR_PEDESTAL.get());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        SpectraliburBlockEntity sword;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SpectraliburBlockEntity && !(sword = (SpectraliburBlockEntity)blockEntity).isOnCooldown()) {
            if (!player.m_21023_(MobEffects.f_19600_) && sword.swordPosition == 0.0f) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_CANT_PULL.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.species.spectralibur.no_strength").m_130948_(Style.f_131099_.m_178520_(8188661)), true);
            } else if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if ((double)sword.getSwordPosition() < 0.9) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.SPECTRALIBUR.get()), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.01f), (double)((float)pos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
                }
                serverLevel.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)SpeciesSoundEvents.SPECTRALIBUR_PULL.get(), SoundSource.BLOCKS, 2.0f, 0.75f + sword.getSwordPosition() * 0.5f);
                float position = sword.getSwordPosition() * 10.0f;
                List list = world.m_6443_(Player.class, new AABB(pos).m_82400_(12.0), EntitySelector.f_20408_);
                int playerCount = list.size();
                if (position > 9.0f) {
                    if (world.m_46791_() == Difficulty.EASY) {
                        world.m_45976_(Spectre.class, new AABB(pos).m_82400_(12.0)).forEach(LivingEntity::m_6074_);
                    }
                    if (world.m_46791_() == Difficulty.PEACEFUL) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.species.spectralibur.peaceful").m_130948_(Style.f_131099_.m_178520_(8188661)), true);
                    }
                    Species.PROXY.screenShake(new ScreenShakeEvent(pos.m_252807_(), 14, 1.0f, 10.0f, false));
                }
                if (position <= 9.0f) {
                    int wave = Math.min((int)position, 9);
                    for (Wave w : WAVES.getOrDefault(wave, List.of())) {
                        int totalSpectres = w.baseCount() + (w.scaleWithPlayers() ? playerCount : 0);
                        for (int i = 0; i < totalSpectres; ++i) {
                            Spectre.spawnSpectre(serverLevel, player, pos.m_7494_(), w.spectreType(), false);
                        }
                    }
                }
            }
            sword.onHit(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, blockHitResult);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        return levelReader.m_8055_(pos.m_7495_()).m_60713_((Block)SpeciesBlocks.SPECTRALIBUR_PEDESTAL.get());
    }

    public BlockState m_7417_(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        return !p_153483_.m_60710_((LevelReader)p_153486_, p_153487_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return SpectraliburBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.SPECTRALIBUR.get()), SpectraliburBlockEntity::tick);
    }

    public record Wave(Spectre.Type spectreType, int baseCount, boolean scaleWithPlayers) {
    }
}

