/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.block.FaceAttachedHorizontalDirectionalBaseEntityBlock;
import com.ninni.species.server.block.entity.SpeclightBlockEntity;
import com.ninni.species.server.block.entity.SpectreLightBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpeclightBlock
extends FaceAttachedHorizontalDirectionalBaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape CEILING_AABB = Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape FLOOR_AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)3.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);

    public SpeclightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACE, (Comparable)AttachFace.WALL));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_53184_) {
        boolean flag;
        FluidState fluidstate = p_53184_.m_43725_().m_6425_(p_53184_.m_8083_());
        boolean bl = flag = fluidstate.m_76152_() == Fluids.f_76193_;
        if (p_53184_.m_43723_().m_6144_()) {
            p_53184_.m_43725_().m_247517_(null, p_53184_.m_8083_(), (SoundEvent)SpeciesSoundEvents.SPECLIGHT_ON.get(), SoundSource.BLOCKS);
        }
        return (BlockState)((BlockState)super.m_5573_(p_53184_).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(p_53184_.m_43723_().m_6144_()));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState state, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, state, levelAccessor, blockPos, blockPos1);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean currentlyPowered = (Boolean)state.m_61143_((Property)POWERED);
        boolean isNowPowered = level.m_276867_(pos);
        if (isNowPowered) {
            level.m_247517_(null, pos, currentlyPowered ? (SoundEvent)SpeciesSoundEvents.SPECLIGHT_OFF.get() : (SoundEvent)SpeciesSoundEvents.SPECLIGHT_ON.get(), SoundSource.BLOCKS);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(!currentlyPowered)), 2);
        }
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return switch ((AttachFace)state.m_61143_((Property)FACE)) {
            case AttachFace.FLOOR -> FLOOR_AABB;
            case AttachFace.WALL -> {
                switch (direction) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                    case NORTH: 
                    case UP: 
                    case DOWN: 
                }
                yield NORTH_AABB;
            }
            default -> CEILING_AABB;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpectreLightBlockEntity) {
            SpectreLightBlockEntity blockEntity2 = (SpectreLightBlockEntity)blockEntity;
            stack.m_41698_("BlockEntityTag").m_128405_("color", blockEntity2.getColor());
        }
        return stack;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (player.m_21120_(hand).m_41619_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf((Boolean)level.m_8055_(pos).m_61143_((Property)POWERED) == false)), 3);
            if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                level.m_247517_(null, pos, (SoundEvent)SpeciesSoundEvents.SPECLIGHT_ON.get(), SoundSource.BLOCKS);
            } else {
                level.m_247517_(null, pos, (SoundEvent)SpeciesSoundEvents.SPECLIGHT_OFF.get(), SoundSource.BLOCKS);
            }
            level.m_142346_((Entity)player, GameEvent.f_223702_, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, FACE, WATERLOGGED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpeclightBlockEntity(pos, state);
    }
}

