/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.model.mob.update_2;

import com.google.common.collect.ImmutableList;
import com.ninni.species.server.entity.mob.update_2.Trooper;
import java.util.Collections;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrooperModel<E extends Trooper>
extends AgeableListModel<E> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public TrooperModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.rightArm = this.root.m_171324_("right_arm");
        this.leftArm = this.root.m_171324_("left_arm");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-2.0f, -7.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition leaves = body.m_171599_("leaves", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-5.0f, -4.0f, 0.0f, 10.0f, 6.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leaves2 = body.m_171599_("leaves2", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171480_().m_171481_(-5.0f, -4.0f, 0.0f, 10.0f, 6.0f, 0.0f).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171481_(-2.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)-2.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171480_().m_171481_(-1.0f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)-2.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171481_(-2.0f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)2.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171480_().m_171481_(-1.0f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections.emptyList();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.root);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        if (entity.m_21825_()) {
            this.body.f_104201_ = 25.0f;
            this.rightLeg.f_104207_ = false;
            this.leftLeg.f_104207_ = false;
            this.rightArm.f_104207_ = false;
            this.leftArm.f_104207_ = false;
        } else {
            this.body.f_104201_ = 20.0f;
            this.rightLeg.f_104207_ = true;
            this.leftLeg.f_104207_ = true;
            this.rightArm.f_104207_ = true;
            this.leftArm.f_104207_ = true;
        }
    }
}

