/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.platform;

import dev.muon.medievalorigins.entity.ModEntities;
import dev.muon.medievalorigins.entity.SummonedSkeleton;
import dev.muon.medievalorigins.entity.SummonedWitherSkeleton;
import dev.muon.medievalorigins.entity.SummonedZombie;
import dev.muon.medievalorigins.platform.services.IEntityHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class ForgeEntityHelper
implements IEntityHelper {
    private static final Map<Class<? extends Entity>, Supplier<EntityType<?>>> ENTITY_TYPES = new HashMap();

    @Override
    public <T extends Entity> EntityType<T> getEntityType(Class<T> entityClass) {
        Supplier<EntityType<?>> supplier = ENTITY_TYPES.get(entityClass);
        if (supplier == null) {
            throw new IllegalArgumentException("No EntityType registered for " + entityClass.getName());
        }
        return supplier.get();
    }

    static {
        ENTITY_TYPES.put(SummonedSkeleton.class, () -> (EntityType)ModEntities.SUMMON_SKELETON.get());
        ENTITY_TYPES.put(SummonedZombie.class, () -> (EntityType)ModEntities.SUMMON_ZOMBIE.get());
        ENTITY_TYPES.put(SummonedWitherSkeleton.class, () -> (EntityType)ModEntities.SUMMON_WITHER_SKELETON.get());
    }
}

