/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.mixin.compat.apoli;

import dev.muon.medievalorigins.util.HarvestContextStack;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnBlockBreakPower;
import io.github.apace100.apoli.util.HarvestContext;
import io.github.apace100.apoli.util.SavedBlockPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerGameModeMixin {
    @Shadow
    protected ServerLevel f_9244_;
    @Final
    @Shadow
    protected ServerPlayer f_9245_;

    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")})
    private void medievalorigins$cacheBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        HarvestContextStack.pushCurrentContext();
        HarvestContext.setBlockPosition((ServerLevel)this.f_9244_, (BlockPos)pos);
        HarvestContext.setCanHarvest((Boolean)this.f_9245_.m_36298_(this.f_9244_.m_8055_(pos)));
    }

    @Inject(method={"destroyBlock"}, at={@At(value="RETURN")})
    private void medievalorigins$onBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            Boolean canHarvest = HarvestContext.getCanHarvest();
            boolean harvested = canHarvest != null ? canHarvest : false;
            SavedBlockPosition blockPosition = HarvestContext.getBlockPosition();
            if (blockPosition != null) {
                PowerHolderComponent.getPowers((Entity)this.f_9245_, ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply((BlockInWorld)blockPosition)).forEach(p -> p.executeActions(harvested, pos, (Direction)null));
            }
        }
        HarvestContext.clearCanHarvest();
        HarvestContext.clearBlockPosition();
        HarvestContextStack.popAndRestoreContext();
    }
}

