/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class AutoPlantSeedsAction {
    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("auto_plant_seeds"), new SerializableData().add("chance", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.25f)).add("block_tag", SerializableDataTypes.IDENTIFIER, (Object)MedievalOrigins.loc("plantable_crop_blocks")).add("horizontal_radius", SerializableDataTypes.INT, (Object)1).add("vertical_radius_player", SerializableDataTypes.INT, (Object)0), AutoPlantSeedsAction::action);
    }

    public static void action(SerializableData.Instance data, Entity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float chance = data.getFloat("chance");
        ResourceLocation tagId = data.getId("block_tag");
        int horizontalRadius = data.getInt("horizontal_radius");
        int verticalRadiusPlayer = data.getInt("vertical_radius_player");
        Random random = new Random();
        if (random.nextFloat() >= chance) {
            return;
        }
        TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagId);
        BlockPos entityBasePos = entity.m_20183_();
        Registry blockRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256747_);
        Optional optionalHolderSet = blockRegistry.m_203431_(blockTagKey);
        if (optionalHolderSet.isEmpty() || ((HolderSet.Named)optionalHolderSet.get()).m_203632_() == 0) {
            return;
        }
        List<Block> possibleBlocks = ((HolderSet.Named)optionalHolderSet.get()).m_203614_().map(Holder::m_203334_).toList();
        if (possibleBlocks.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> potentialPlantingSpots = new ArrayList<BlockPos>();
        for (int yOff = -verticalRadiusPlayer; yOff <= verticalRadiusPlayer; ++yOff) {
            for (int xOff = -horizontalRadius; xOff <= horizontalRadius; ++xOff) {
                for (int zOff = -horizontalRadius; zOff <= horizontalRadius; ++zOff) {
                    BlockPos candidatePlantPos = entityBasePos.m_7918_(xOff, yOff, zOff);
                    BlockPos candidateFarmlandPos = candidatePlantPos.m_7495_();
                    if (!level.m_8055_(candidatePlantPos).m_60795_() || !(level.m_8055_(candidateFarmlandPos).m_60734_() instanceof FarmBlock)) continue;
                    potentialPlantingSpots.add(candidatePlantPos);
                }
            }
        }
        if (potentialPlantingSpots.isEmpty()) {
            return;
        }
        Collections.shuffle(potentialPlantingSpots, random);
        for (BlockPos plantPos : potentialPlantingSpots) {
            Block selectedBlock;
            BlockState plantState;
            if (!level.m_8055_(plantPos).m_60795_() || !(level.m_8055_(plantPos.m_7495_()).m_60734_() instanceof FarmBlock) || !(plantState = (selectedBlock = possibleBlocks.get(random.nextInt(possibleBlocks.size()))).m_49966_()).m_60710_((LevelReader)serverLevel, plantPos) || !serverLevel.m_7731_(plantPos, plantState, 3)) continue;
            serverLevel.m_5594_(null, plantPos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
            serverLevel.m_142346_(entity, GameEvent.f_157797_, plantPos);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)plantPos.m_123341_() + 0.5, (double)plantPos.m_123342_() + 0.5, (double)plantPos.m_123343_() + 0.5, 5, 0.3, 0.3, 0.3, 0.0);
            return;
        }
    }
}

