/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.platform.Services;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SpellHealAction {
    public static ActionFactory<Tuple<Entity, Entity>> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("spell_heal"), new SerializableData().add("magic_school", SerializableDataTypes.STRING).add("crit_behavior", SerializableDataTypes.STRING, (Object)"normal").add("base", SerializableDataTypes.FLOAT).add("scaling_factor", SerializableDataTypes.FLOAT).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null), SpellHealAction::action);
    }

    public static void action(SerializableData.Instance data, Tuple<Entity, Entity> entities) {
        Entity actor = (Entity)entities.m_14418_();
        Entity target = (Entity)entities.m_14419_();
        if (!(actor instanceof LivingEntity) || !(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        float baseHeal = ((Float)data.get("base")).floatValue();
        float scalingFactor = ((Float)data.get("scaling_factor")).floatValue();
        String magicSchool = (String)data.get("magic_school");
        String critBehavior = (String)data.get("crit_behavior");
        double spellPower = Services.SPELL_POWER.getSpellPower(magicSchool, (LivingEntity)actor, critBehavior);
        double totalHeal = (double)baseHeal + spellPower * (double)scalingFactor;
        livingEntity.m_5634_((float)totalHeal);
    }
}

