/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.screen;

import java.awt.Desktop;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MissingConnectorModDependencyScreen
extends Screen {
    private final List<Component> lines = new ArrayList<Component>();
    private final String titleLine;
    private final String subtitleLine;
    private double scrollOffset = 0.0;

    public MissingConnectorModDependencyScreen(Component content, String titleLine, String subtitleLine) {
        super(Component.m_130674_((String)"Exception"));
        this.titleLine = titleLine;
        this.subtitleLine = subtitleLine;
        String raw = content.getString();
        if (raw.contains("\n")) {
            for (String ln : raw.split("\\r?\\n")) {
                this.lines.add((Component)Component.m_237113_((String)ln));
            }
        } else {
            this.lines.add(content);
        }
    }

    public MissingConnectorModDependencyScreen(List<Component> lines, String titleLine, String subtitleLine) {
        super(Component.m_130674_((String)"Exception"));
        this.titleLine = titleLine;
        this.subtitleLine = subtitleLine;
        this.lines.addAll(lines);
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 160;
        int buttonHeight = 20;
        int spacing = 8;
        int totalWidth = 496;
        int startX = (this.f_96543_ - 496) / 2;
        int y = this.f_96544_ - 35;
        Button modsBtn = Button.m_253074_((Component)Component.m_130674_((String)"Open Mods Folder"), btn -> {
            try {
                Path mods = FabricLoader.getInstance().getGameDir().resolve("mods");
                this.openPath(mods);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).m_252794_(startX + 160 + 8, y).m_253046_(160, 20).m_253136_();
        this.m_142416_((GuiEventListener)modsBtn);
    }

    private void openPath(Path p) throws Exception {
        File f = p.toFile();
        if (!f.exists()) {
            File parent = f.getParentFile();
            if (parent != null && parent.exists()) {
                this.openFile(parent);
            }
            return;
        }
        this.openFile(f);
    }

    private void openFile(File f) throws Exception {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(f);
        } else {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("mac")) {
                Runtime.getRuntime().exec(new String[]{"open", f.getAbsolutePath()});
            } else if (os.contains("nix") || os.contains("nux")) {
                Runtime.getRuntime().exec(new String[]{"xdg-open", f.getAbsolutePath()});
            } else if (os.contains("win")) {
                Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", f.getAbsolutePath()});
            } else {
                throw new UnsupportedOperationException("Cannot open file on this OS: " + os);
            }
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int topPadding;
        int leftPadding;
        this.m_280273_(context);
        Font tr = this.f_96547_;
        int centreX = this.f_96543_ / 2;
        int y = 15;
        int titleWidth = tr.m_92895_(this.titleLine);
        context.m_280430_(tr, Component.m_130674_((String)this.titleLine), centreX - titleWidth / 2, y, 0xFF5555);
        Objects.requireNonNull(tr);
        int subtitleWidth = tr.m_92895_(this.subtitleLine);
        context.m_280430_(tr, Component.m_130674_((String)this.subtitleLine), centreX - subtitleWidth / 2, y += 9 + 2, 0xFF5555);
        Objects.requireNonNull(tr);
        y += 9 + 6;
        int areaX = leftPadding = 20;
        int areaY = topPadding = 50;
        int rightPadding = 20;
        int areaWidth = this.f_96543_ - leftPadding - rightPadding;
        int bottomButtonAreaHeight = 50;
        int areaHeight = this.f_96544_ - topPadding - bottomButtonAreaHeight - 10;
        context.m_280509_(areaX - 4, areaY - 4, areaX + areaWidth + 4, areaY + areaHeight + 4, -2013265920);
        this.drawRectOutline(context, areaX - 4, areaY - 4, areaX + areaWidth + 4, areaY + areaHeight + 4, -13421773);
        ArrayList wrappedLines = new ArrayList();
        for (Component line : this.lines) {
            wrappedLines.addAll(tr.m_92923_((FormattedText)line, areaWidth));
        }
        Objects.requireNonNull(tr);
        int fh = 9;
        int maxVisibleLines = Math.max(1, areaHeight / fh);
        double maxScroll = Math.max(0, wrappedLines.size() - maxVisibleLines);
        this.scrollOffset = Math.max(0.0, Math.min(this.scrollOffset, maxScroll));
        int startLine = (int)Math.floor(this.scrollOffset);
        int endLine = Math.min(wrappedLines.size(), startLine + maxVisibleLines);
        context.m_280588_(areaX, areaY, areaX + areaWidth, areaY + areaHeight);
        int drawY = areaY;
        for (int i = startLine; i < endLine; ++i) {
            context.m_280648_(tr, (FormattedCharSequence)wrappedLines.get(i), areaX, drawY, 0xFFFFFF);
            drawY += fh;
        }
        context.m_280618_();
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    private void drawRectOutline(GuiGraphics ctx, int x1, int y1, int x2, int y2, int color) {
        ctx.m_280509_(x1, y1, x2, y1 + 1, color);
        ctx.m_280509_(x1, y2 - 1, x2, y2, color);
        ctx.m_280509_(x1, y1, x1 + 1, y2, color);
        ctx.m_280509_(x2 - 1, y1, x2, y2, color);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollOffset -= amount * 3.0;
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

