/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.mixin.integration.connector;

import io.github.apace100.calio.screen.MissingConnectorModDependencyScreen;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class TitleScreenMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void openScreen(CallbackInfo ci) {
        List<Component> errorText;
        if (FabricLoader.getInstance().isModLoaded("connectormod") && !(errorText = TitleScreenMixin.buildConnectorDependencyText()).isEmpty()) {
            String subtitle = errorText.size() == 1 ? "1 error has occurred during loading" : errorText.size() + " errors have occured during loading";
            Minecraft.m_91087_().m_91152_((Screen)new MissingConnectorModDependencyScreen(errorText, "Error loading mods", subtitle));
        }
    }

    @Unique
    private static List<Component> buildConnectorDependencyText() {
        ArrayList<Component> lines = new ArrayList<Component>();
        FabricLoader.getInstance().getAllMods().forEach(mod -> {
            String modId = mod.getMetadata().getId();
            CustomValue value = mod.getMetadata().getCustomValue("connector-depends");
            if (value != null && value.getType() == CustomValue.CvType.OBJECT) {
                CustomValue.CvObject obj = value.getAsObject();
                obj.forEach(customValueEntry -> {
                    String depId = (String)customValueEntry.getKey();
                    if (!FabricLoader.getInstance().isModLoaded(depId)) {
                        String version;
                        CustomValue depVal = (CustomValue)customValueEntry.getValue();
                        String displayName = null;
                        if (depVal.getType() == CustomValue.CvType.STRING) {
                            version = depVal.getAsString();
                        } else if (depVal.getType() == CustomValue.CvType.OBJECT) {
                            CustomValue.CvObject depObj = depVal.getAsObject();
                            String string = version = depObj.containsKey("version") ? depObj.get("version").getAsString() : "unknown";
                            if (depObj.containsKey("name")) {
                                displayName = depObj.get("name").getAsString();
                            }
                        } else {
                            version = "unknown";
                        }
                        MutableComponent line = Component.m_237113_((String)"Mod ").m_7220_((Component)Component.m_237113_((String)modId).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" requires ")).m_7220_((Component)Component.m_237113_((String)depId).m_130940_(ChatFormatting.GOLD));
                        if (displayName != null && !displayName.isEmpty()) {
                            line = line.m_7220_((Component)Component.m_237113_((String)(" (" + displayName + ")")).m_130940_(ChatFormatting.GRAY));
                        }
                        line = line.m_7220_((Component)Component.m_237113_((String)(" " + version)).m_130940_(ChatFormatting.ITALIC));
                        lines.add((Component)line);
                    }
                });
            }
        });
        return lines;
    }
}

