/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.mixin;

import io.github.apace100.calio.Calio;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public abstract class CustomNonItalicNameMixin {

    @Mixin(value={AnvilMenu.class})
    public static abstract class RemoveNonItalicOnRename {
        @Inject(method={"updateResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;setCustomName(Lnet/minecraft/text/Text;)Lnet/minecraft/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD)
        private void removeNonItalicFlag(CallbackInfo ci, ItemStack itemStack, int i, int j, int k, ItemStack itemStack2) {
            CompoundTag display = itemStack2.m_41737_("display");
            if (display != null && display.m_128441_("NonItalicName")) {
                display.m_128473_("NonItalicName");
            }
        }
    }

    @Mixin(value={Gui.class})
    public static abstract class ModifyItalicDisplayHud {
        @Redirect(method={"renderHeldItemTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasCustomName()Z"))
        private boolean hasCustomNameWhichIsItalic(ItemStack stack) {
            return stack.m_41788_() && !Calio.hasNonItalicName(stack);
        }
    }

    @Mixin(value={ItemStack.class})
    public static abstract class ModifyItalicDisplayItem {
        @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasCustomName()Z"))
        private boolean hasCustomNameWhichIsItalic(ItemStack stack) {
            return stack.m_41788_() && !Calio.hasNonItalicName(stack);
        }
    }
}

