/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LazilyParsedNumber;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.SerializationHelper;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.util.ArgumentWrapper;
import io.github.apace100.calio.util.StatusEffectChance;
import io.github.apace100.calio.util.TagLike;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;

public final class SerializableDataTypes {
    public static final SerializableDataType<Integer> INT = new SerializableDataType<Integer>(Integer.class, FriendlyByteBuf::writeInt, FriendlyByteBuf::readInt, JsonElement::getAsInt);
    public static final SerializableDataType<List<Integer>> INTS = SerializableDataType.list(INT);
    public static final SerializableDataType<Boolean> BOOLEAN = new SerializableDataType<Boolean>(Boolean.class, FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean, JsonElement::getAsBoolean);
    public static final SerializableDataType<Float> FLOAT = new SerializableDataType<Float>(Float.class, FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat, JsonElement::getAsFloat);
    public static final SerializableDataType<List<Float>> FLOATS = SerializableDataType.list(FLOAT);
    public static final SerializableDataType<Double> DOUBLE = new SerializableDataType<Double>(Double.class, FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble, JsonElement::getAsDouble);
    public static final SerializableDataType<List<Double>> DOUBLES = SerializableDataType.list(DOUBLE);
    public static final SerializableDataType<String> STRING = new SerializableDataType<String>(String.class, FriendlyByteBuf::m_130070_, buf -> buf.m_130136_(Short.MAX_VALUE), JsonElement::getAsString);
    public static final SerializableDataType<List<String>> STRINGS = SerializableDataType.list(STRING);
    public static final SerializableDataType<Number> NUMBER = new SerializableDataType<Number>(Number.class, (buf, number) -> {
        if (number instanceof Double) {
            buf.writeByte(0);
            buf.writeDouble(number.doubleValue());
        } else if (number instanceof Float) {
            buf.writeByte(1);
            buf.writeFloat(number.floatValue());
        } else if (number instanceof Integer) {
            buf.writeByte(2);
            buf.writeInt(number.intValue());
        } else if (number instanceof Long) {
            buf.writeByte(3);
            buf.writeLong(number.longValue());
        } else {
            buf.writeByte(4);
            buf.m_130070_(number.toString());
        }
    }, buf -> {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return buf.readDouble();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readInt();
            }
            case 3: {
                return buf.readLong();
            }
            case 4: {
                return new LazilyParsedNumber(buf.m_130277_());
            }
        }
        throw new RuntimeException("Could not receive number, unexpected type id \"" + type + "\" (allowed range: [0-4])");
    }, je -> {
        if (je.isJsonPrimitive()) {
            JsonPrimitive primitive = je.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? 1 : 0;
            }
        }
        throw new JsonParseException("Expected a primitive");
    });
    public static final SerializableDataType<List<Number>> NUMBERS = SerializableDataType.list(NUMBER);
    public static final SerializableDataType<Vec3> VECTOR = new SerializableDataType<Vec3>(Vec3.class, (packetByteBuf, vector3d) -> {
        packetByteBuf.writeDouble(vector3d.f_82479_);
        packetByteBuf.writeDouble(vector3d.f_82480_);
        packetByteBuf.writeDouble(vector3d.f_82481_);
    }, packetByteBuf -> new Vec3(packetByteBuf.readDouble(), packetByteBuf.readDouble(), packetByteBuf.readDouble()), jsonElement -> {
        if (jsonElement.isJsonObject()) {
            JsonObject jo = jsonElement.getAsJsonObject();
            return new Vec3(GsonHelper.m_144742_((JsonObject)jo, (String)"x", (double)0.0), GsonHelper.m_144742_((JsonObject)jo, (String)"y", (double)0.0), GsonHelper.m_144742_((JsonObject)jo, (String)"z", (double)0.0));
        }
        throw new JsonParseException("Expected an object with x, y, and z fields.");
    });
    public static final SerializableDataType<ResourceLocation> IDENTIFIER = new SerializableDataType<ResourceLocation>(ResourceLocation.class, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_, json -> {
        Object idString = json.getAsString();
        if (((String)idString).contains(":")) {
            String[] idSplit = ((String)idString).split(":");
            if (idSplit.length != 2) {
                throw new ResourceLocationException("Incorrect number of `:` in identifier: \"" + (String)idString + "\".");
            }
            if (idSplit[0].contains("*")) {
                if (SerializableData.CURRENT_NAMESPACE != null) {
                    idSplit[0] = idSplit[0].replace("*", SerializableData.CURRENT_NAMESPACE);
                } else {
                    throw new ResourceLocationException("Identifier may not contain a `*` in the namespace when read here.");
                }
            }
            if (idSplit[1].contains("*")) {
                if (SerializableData.CURRENT_PATH != null) {
                    idSplit[1] = idSplit[1].replace("*", SerializableData.CURRENT_PATH);
                } else {
                    throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
                }
            }
            idString = idSplit[0] + ":" + idSplit[1];
        } else if (((String)idString).contains("*")) {
            if (SerializableData.CURRENT_PATH != null) {
                idString = ((String)idString).replace("*", SerializableData.CURRENT_PATH);
            } else {
                throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
            }
        }
        return new ResourceLocation((String)idString);
    });
    public static final SerializableDataType<List<ResourceLocation>> IDENTIFIERS = SerializableDataType.list(IDENTIFIER);
    public static final SerializableDataType<Enchantment> ENCHANTMENT = SerializableDataType.registry(Enchantment.class, BuiltInRegistries.f_256876_);
    public static SerializableDataType<ResourceKey<Level>> DIMENSION = SerializableDataType.registryKey(Registries.f_256858_);
    public static final SerializableDataType<Attribute> ATTRIBUTE = SerializableDataType.registry(Attribute.class, BuiltInRegistries.f_256951_);
    public static final SerializableDataType<AttributeModifier.Operation> MODIFIER_OPERATION = SerializableDataType.enumValue(AttributeModifier.Operation.class);
    public static final SerializableDataType<AttributeModifier> ATTRIBUTE_MODIFIER = SerializableDataType.compound(AttributeModifier.class, new SerializableData().add("name", STRING, "Unnamed attribute modifier").add("operation", MODIFIER_OPERATION).add("value", DOUBLE), data -> new AttributeModifier(data.getString("name"), data.getDouble("value"), (AttributeModifier.Operation)data.get("operation")), (serializableData, modifier) -> {
        SerializableData.Instance inst = (SerializableData)serializableData.new SerializableData.Instance();
        inst.set("name", modifier.m_22214_());
        inst.set("value", modifier.m_22218_());
        inst.set("operation", modifier.m_22217_());
        return inst;
    });
    public static final SerializableDataType<List<AttributeModifier>> ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<Item> ITEM = SerializableDataType.registry(Item.class, BuiltInRegistries.f_257033_);
    public static final SerializableDataType<MobEffect> STATUS_EFFECT = SerializableDataType.registry(MobEffect.class, BuiltInRegistries.f_256974_);
    public static final SerializableDataType<List<MobEffect>> STATUS_EFFECTS = SerializableDataType.list(STATUS_EFFECT);
    public static final SerializableDataType<MobEffectInstance> STATUS_EFFECT_INSTANCE = new SerializableDataType<MobEffectInstance>(MobEffectInstance.class, SerializationHelper::writeStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::readStatusEffect);
    public static final SerializableDataType<List<MobEffectInstance>> STATUS_EFFECT_INSTANCES = SerializableDataType.list(STATUS_EFFECT_INSTANCE);
    public static final SerializableDataType<TagKey<Item>> ITEM_TAG = SerializableDataType.tag(Registries.f_256913_);
    public static final SerializableDataType<TagKey<Fluid>> FLUID_TAG = SerializableDataType.tag(Registries.f_256808_);
    public static final SerializableDataType<TagKey<Block>> BLOCK_TAG = SerializableDataType.tag(Registries.f_256747_);
    public static final SerializableDataType<TagKey<EntityType<?>>> ENTITY_TAG = SerializableDataType.tag(Registries.f_256939_);
    public static final SerializableDataType<Ingredient.Value> INGREDIENT_ENTRY = SerializableDataType.compound(ClassUtil.castClass(Ingredient.Value.class), new SerializableData().add("item", ITEM, null).add("tag", ITEM_TAG, null), dataInstance -> {
        boolean itemPresent;
        boolean tagPresent = dataInstance.isPresent("tag");
        if (tagPresent == (itemPresent = dataInstance.isPresent("item"))) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, " + (tagPresent ? "not both" : "one has to be provided."));
        }
        if (tagPresent) {
            TagKey tag = (TagKey)dataInstance.get("tag");
            return new Ingredient.TagValue(tag);
        }
        return new Ingredient.ItemValue(new ItemStack((ItemLike)((Item)dataInstance.get("item"))));
    }, (data, entry) -> data.read(entry.m_6544_()));
    public static final SerializableDataType<List<Ingredient.Value>> INGREDIENT_ENTRIES = SerializableDataType.list(INGREDIENT_ENTRY);
    public static final SerializableDataType<Ingredient> INGREDIENT = new SerializableDataType<Ingredient>(Ingredient.class, (buffer, ingredient) -> ingredient.m_43923_(buffer), Ingredient::m_43940_, jsonElement -> {
        List<Ingredient.Value> entryList = INGREDIENT_ENTRIES.read((JsonElement)jsonElement);
        return Ingredient.m_43938_(entryList.stream());
    });
    public static final SerializableDataType<Ingredient> VANILLA_INGREDIENT = new SerializableDataType<Ingredient>(Ingredient.class, (buffer, ingredient) -> ingredient.m_43923_(buffer), Ingredient::m_43940_, Ingredient::m_43917_);
    public static final SerializableDataType<Block> BLOCK = SerializableDataType.registry(Block.class, BuiltInRegistries.f_256975_);
    public static final SerializableDataType<BlockState> BLOCK_STATE = SerializableDataType.wrap(BlockState.class, STRING, BlockStateParser::m_116769_, string -> {
        try {
            return BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)string, (boolean)false).f_234748_();
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException((Throwable)e);
        }
    });
    public static final SerializableDataType<ResourceKey<DamageType>> DAMAGE_TYPE = SerializableDataType.registryKey(Registries.f_268580_);
    public static final SerializableDataType<MobType> ENTITY_GROUP = SerializableDataType.mapped(MobType.class, HashBiMap.create((Map)ImmutableMap.of((Object)"default", (Object)MobType.f_21640_, (Object)"undead", (Object)MobType.f_21641_, (Object)"arthropod", (Object)MobType.f_21642_, (Object)"illager", (Object)MobType.f_21643_, (Object)"aquatic", (Object)MobType.f_21644_)));
    public static final SerializableDataType<EquipmentSlot> EQUIPMENT_SLOT = SerializableDataType.enumValue(EquipmentSlot.class);
    public static final SerializableDataType<SoundEvent> SOUND_EVENT = SerializableDataType.registry(SoundEvent.class, BuiltInRegistries.f_256894_);
    public static final SerializableDataType<EntityType<?>> ENTITY_TYPE = SerializableDataType.registry(ClassUtil.castClass(EntityType.class), BuiltInRegistries.f_256780_);
    public static final SerializableDataType<ParticleType<?>> PARTICLE_TYPE = SerializableDataType.registry(ClassUtil.castClass(ParticleType.class), BuiltInRegistries.f_257034_);
    public static final SerializableDataType<ParticleOptions> PARTICLE_EFFECT = SerializableDataType.compound(ParticleOptions.class, new SerializableData().add("type", PARTICLE_TYPE).add("params", STRING, ""), dataInstance -> {
        ParticleType particleType = (ParticleType)dataInstance.get("type");
        ParticleOptions.Deserializer factory = particleType.m_123743_();
        ParticleOptions effect = null;
        try {
            effect = factory.m_5739_(particleType, new StringReader(" " + dataInstance.getString("params")));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return effect;
    }, (serializableData, particleEffect) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("type", particleEffect.m_6012_());
        String params = particleEffect.m_5942_();
        int spaceIndex = params.indexOf(32);
        params = spaceIndex > -1 ? params.substring(spaceIndex + 1) : "";
        data.set("params", params);
        return data;
    });
    public static final SerializableDataType<ParticleOptions> PARTICLE_EFFECT_OR_TYPE = new SerializableDataType<ParticleOptions>(ParticleOptions.class, PARTICLE_EFFECT::send, PARTICLE_EFFECT::receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            ParticleType<?> type = PARTICLE_TYPE.read((JsonElement)jsonElement);
            if (type instanceof ParticleOptions) {
                return (ParticleOptions)type;
            }
            throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
        }
        if (jsonElement.isJsonObject()) {
            return PARTICLE_EFFECT.read((JsonElement)jsonElement);
        }
        throw new RuntimeException("Expected either a string with a parameter-less particle effect, or an object.");
    });
    public static final SerializableDataType<CompoundTag> NBT = new SerializableDataType<CompoundTag>(CompoundTag.class, FriendlyByteBuf::m_130079_, FriendlyByteBuf::m_130260_, jsonElement -> {
        if (!(jsonElement.isJsonObject() || jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString())) {
            throw new JsonSyntaxException("Expected either a string or an object.");
        }
        try {
            String stringifiedJsonElement = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject().toString() : jsonElement.getAsJsonPrimitive().getAsString();
            return new TagParser(new StringReader(stringifiedJsonElement)).m_129373_();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Could not parse NBT: " + e.getMessage());
        }
    });
    public static final SerializableDataType<ItemStack> ITEM_STACK = SerializableDataType.compound(ItemStack.class, new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null), data -> {
        ItemStack stack = new ItemStack((ItemLike)((Item)data.get("item")), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.m_41751_((CompoundTag)data.get("tag"));
        }
        return stack;
    }, (serializableData, itemStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", itemStack.m_41720_());
        data.set("amount", itemStack.m_41613_());
        data.set("tag", itemStack.m_41782_() ? itemStack.m_41783_() : null);
        return data;
    });
    public static final SerializableDataType<List<ItemStack>> ITEM_STACKS = SerializableDataType.list(ITEM_STACK);
    public static final SerializableDataType<Component> TEXT = new SerializableDataType<Component>(Component.class, (buffer, text) -> buffer.m_130070_(Component.Serializer.m_130703_((Component)text)), buffer -> Component.Serializer.m_130701_((String)buffer.m_130136_(Short.MAX_VALUE)), Component.Serializer::m_130691_);
    public static final SerializableDataType<List<Component>> TEXTS = SerializableDataType.list(TEXT);
    public static final SerializableDataType<Recipe> RECIPE = new SerializableDataType<Recipe>(Recipe.class, (buffer, recipe) -> {
        buffer.m_130085_(BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()));
        buffer.m_130085_(recipe.m_6423_());
        recipe.m_7707_().m_6178_(buffer, recipe);
    }, buffer -> {
        ResourceLocation recipeSerializerId = buffer.m_130281_();
        ResourceLocation recipeId = buffer.m_130281_();
        RecipeSerializer serializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(recipeSerializerId);
        return serializer.m_8005_(recipeId, buffer);
    }, jsonElement -> {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Expected recipe to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        ResourceLocation recipeSerializerId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        ResourceLocation recipeId = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"id"));
        RecipeSerializer serializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(recipeSerializerId);
        return serializer.m_6729_(recipeId, json);
    });
    public static final SerializableDataType<GameEvent> GAME_EVENT = SerializableDataType.registry(GameEvent.class, BuiltInRegistries.f_256726_);
    public static final SerializableDataType<List<GameEvent>> GAME_EVENTS = SerializableDataType.list(GAME_EVENT);
    public static final SerializableDataType<TagKey<GameEvent>> GAME_EVENT_TAG = SerializableDataType.tag(Registries.f_256827_);
    public static final SerializableDataType<Fluid> FLUID = SerializableDataType.registry(Fluid.class, BuiltInRegistries.f_257020_);
    public static final SerializableDataType<FogType> CAMERA_SUBMERSION_TYPE = SerializableDataType.enumValue(FogType.class);
    public static final SerializableDataType<InteractionHand> HAND = SerializableDataType.enumValue(InteractionHand.class);
    public static final SerializableDataType<EnumSet<InteractionHand>> HAND_SET = SerializableDataType.enumSet(InteractionHand.class, HAND);
    public static final SerializableDataType<EnumSet<EquipmentSlot>> EQUIPMENT_SLOT_SET = SerializableDataType.enumSet(EquipmentSlot.class, EQUIPMENT_SLOT);
    public static final SerializableDataType<InteractionResult> ACTION_RESULT = SerializableDataType.enumValue(InteractionResult.class);
    public static final SerializableDataType<UseAnim> USE_ACTION = SerializableDataType.enumValue(UseAnim.class);
    public static final SerializableDataType<StatusEffectChance> STATUS_EFFECT_CHANCE = SerializableDataType.compound(StatusEffectChance.class, new SerializableData().add("effect", STATUS_EFFECT_INSTANCE).add("chance", FLOAT, Float.valueOf(1.0f)), data -> {
        StatusEffectChance sec = new StatusEffectChance();
        sec.statusEffectInstance = (MobEffectInstance)data.get("effect");
        sec.chance = data.getFloat("chance");
        return sec;
    }, (data, csei) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("effect", csei.statusEffectInstance);
        inst.set("chance", Float.valueOf(csei.chance));
        return inst;
    });
    public static final SerializableDataType<List<StatusEffectChance>> STATUS_EFFECT_CHANCES = SerializableDataType.list(STATUS_EFFECT_CHANCE);
    public static final SerializableDataType<FoodProperties> FOOD_COMPONENT = SerializableDataType.compound(FoodProperties.class, new SerializableData().add("hunger", INT).add("saturation", FLOAT).add("meat", BOOLEAN, false).add("always_edible", BOOLEAN, false).add("snack", BOOLEAN, false).add("effect", STATUS_EFFECT_CHANCE, null).add("effects", STATUS_EFFECT_CHANCES, null), data -> {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(data.getInt("hunger")).m_38758_(data.getFloat("saturation"));
        if (data.getBoolean("meat")) {
            builder.m_38757_();
        }
        if (data.getBoolean("always_edible")) {
            builder.m_38765_();
        }
        if (data.getBoolean("snack")) {
            builder.m_38766_();
        }
        data.ifPresent("effect", sec -> builder.m_38762_(sec.statusEffectInstance, sec.chance));
        data.ifPresent("effects", secs -> secs.forEach(sec -> builder.m_38762_(sec.statusEffectInstance, sec.chance)));
        return builder.m_38767_();
    }, (data, fc) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("hunger", fc.m_38744_());
        inst.set("saturation", Float.valueOf(fc.m_38745_()));
        inst.set("meat", fc.m_38746_());
        inst.set("always_edible", fc.m_38747_());
        inst.set("snack", fc.m_38748_());
        inst.set("effect", null);
        LinkedList statusEffectChances = new LinkedList();
        fc.m_38749_().forEach(pair -> {
            StatusEffectChance sec = new StatusEffectChance();
            sec.statusEffectInstance = (MobEffectInstance)pair.getFirst();
            sec.chance = ((Float)pair.getSecond()).floatValue();
            statusEffectChances.add(sec);
        });
        if (statusEffectChances.size() > 0) {
            inst.set("effects", statusEffectChances);
        } else {
            inst.set("effects", null);
        }
        return inst;
    });
    public static final SerializableDataType<Direction> DIRECTION = SerializableDataType.enumValue(Direction.class);
    public static final SerializableDataType<EnumSet<Direction>> DIRECTION_SET = SerializableDataType.enumSet(Direction.class, DIRECTION);
    public static final SerializableDataType<Class<?>> CLASS = SerializableDataType.wrap(ClassUtil.castClass(Class.class), STRING, Class::getName, str -> {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified class does not exist: \"" + str + "\".");
        }
    });
    public static final SerializableDataType<ClipContext.Block> SHAPE_TYPE = SerializableDataType.enumValue(ClipContext.Block.class);
    public static final SerializableDataType<ClipContext.Fluid> FLUID_HANDLING = SerializableDataType.enumValue(ClipContext.Fluid.class);
    public static final SerializableDataType<Explosion.BlockInteraction> DESTRUCTION_TYPE = SerializableDataType.enumValue(Explosion.BlockInteraction.class);
    public static final SerializableDataType<Direction.Axis> AXIS = SerializableDataType.enumValue(Direction.Axis.class);
    public static final SerializableDataType<EnumSet<Direction.Axis>> AXIS_SET = SerializableDataType.enumSet(Direction.Axis.class, AXIS);
    public static final SerializableDataType<ArgumentWrapper<NbtPathArgument.NbtPath>> NBT_PATH = SerializableDataType.argumentType(NbtPathArgument.m_99487_());
    public static final SerializableDataType<ClipContext.Block> RAYCAST_SHAPE_TYPE = SerializableDataType.enumValue(ClipContext.Block.class);
    public static final SerializableDataType<ClipContext.Fluid> RAYCAST_FLUID_HANDLING = SerializableDataType.enumValue(ClipContext.Fluid.class);
    public static final SerializableDataType<Stat<?>> STAT = SerializableDataType.compound(ClassUtil.castClass(Stat.class), new SerializableData().add("type", SerializableDataType.registry(ClassUtil.castClass(StatType.class), BuiltInRegistries.f_256899_)).add("id", IDENTIFIER), data -> {
        ResourceLocation statId;
        StatType statType = (StatType)data.get("type");
        Registry statRegistry = statType.m_12893_();
        if (statRegistry.m_7804_(statId = (ResourceLocation)data.get("id"))) {
            Object statObject = statRegistry.m_7745_(statId);
            return statType.m_12902_(statObject);
        }
        throw new IllegalArgumentException("Desired stat \"" + statId + "\" does not exist in stat type ");
    }, (data, stat) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("type", stat.m_12859_());
        Registry reg = stat.m_12859_().m_12893_();
        ResourceLocation statId = reg.m_7981_(stat.m_12867_());
        inst.set("id", statId);
        return inst;
    });
    public static final SerializableDataType<TagKey<Biome>> BIOME_TAG = SerializableDataType.tag(Registries.f_256952_);
    public static final SerializableDataType<TagLike<Item>> ITEM_TAG_LIKE = SerializableDataType.tagLike(BuiltInRegistries.f_257033_);
    public static final SerializableDataType<TagLike<Block>> BLOCK_TAG_LIKE = SerializableDataType.tagLike(BuiltInRegistries.f_256975_);
    public static final SerializableDataType<TagLike<EntityType<?>>> ENTITY_TYPE_TAG_LIKE = SerializableDataType.tagLike(BuiltInRegistries.f_256780_);
}

