/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.NormalSampler;
import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PoissonSampler
extends RandomSampler {
    public static final MapCodec<PoissonSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("lambda").forGetter(PoissonSampler::lambda)).apply((Applicative)instance, PoissonSampler::create));
    public static final AnonymousTypedCodec<PoissonSampler> ANON_CODEC = new AnonymousTypedCodec<PoissonSampler>("poisson", CODEC);

    public static PoissonSampler create(double lambda) {
        if (lambda < 30.0) {
            double expNegativeLambda = StrictMath.exp(-lambda);
            return new Knuth(lambda, expNegativeLambda);
        }
        return new Normal(lambda, NormalSampler.create(lambda, StrictMath.sqrt(lambda)));
    }

    public double lambda();

    @Override
    default public double minValue() {
        return 0.0;
    }

    @Override
    default public double maxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    default public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }

    public record Knuth(double lambda, double expNegativeLambda) implements PoissonSampler
    {
        @Override
        public double sample(long hashedSeed) {
            double p = 1.0;
            int k = 0;
            do {
                ++k;
            } while ((p *= RandomSampler.sampleDouble(hashedSeed = RandomSampler.mix(hashedSeed))) > this.expNegativeLambda);
            return (double)k - 1.0;
        }
    }

    public record Normal(double lambda, NormalSampler normalSampler) implements PoissonSampler
    {
        @Override
        public double sample(long hashedSeed) {
            return StrictMath.max(0.0, (double)StrictMath.round(this.normalSampler.sample(hashedSeed)));
        }
    }
}

