/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record NormalSampler(double mean, double stdDev) implements RandomSampler
{
    private static final MapCodec<NormalSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("mean").forGetter(NormalSampler::mean), (App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)Double.MAX_VALUE).fieldOf("std_dev").forGetter(NormalSampler::stdDev)).apply((Applicative)instance, NormalSampler::create));
    public static final AnonymousTypedCodec<NormalSampler> ANON_CODEC = new AnonymousTypedCodec<NormalSampler>("normal", CODEC);

    public static NormalSampler create(double mean, double stdDev) {
        return new NormalSampler(mean, stdDev);
    }

    @Override
    public double sample(long hashedSeed) {
        return this.mean + this.stdDev * RandomSampler.sampleGaussian(hashedSeed);
    }

    @Override
    public double minValue() {
        return -1.7976931348623157E308;
    }

    @Override
    public double maxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }
}

