/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.ExponentialSampler;
import com.klinbee.moredensityfunctions.randomsamplers.NormalSampler;
import com.klinbee.moredensityfunctions.randomsamplers.PoissonSampler;
import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BinomialSampler
extends RandomSampler {
    public static final MapCodec<BinomialSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)1000000).fieldOf("trials").forGetter(BinomialSampler::trials), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("probability").forGetter(BinomialSampler::probability)).apply((Applicative)instance, BinomialSampler::create));
    public static final AnonymousTypedCodec<BinomialSampler> ANON_CODEC = new AnonymousTypedCodec<BinomialSampler>("binomial", CODEC);

    public static BinomialSampler create(int trials, double probability) {
        if (trials < 30) {
            return new Direct(trials, probability);
        }
        double mean = (double)trials * probability;
        if (mean < 10.0) {
            PoissonSampler randPoisson = PoissonSampler.create(mean);
            return new Poisson(trials, probability, randPoisson);
        }
        double oppositeMean = (double)trials * (1.0 - probability);
        if (mean >= 30.0 && oppositeMean >= 30.0) {
            NormalSampler normalSampler = NormalSampler.create(mean, StrictMath.sqrt(mean * (1.0 - probability)));
            return new Normal(trials, probability, normalSampler);
        }
        ExponentialSampler exponentialSampler = ExponentialSampler.create(-StrictMath.log(1.0 - probability));
        return new Exponential(trials, probability, exponentialSampler);
    }

    public int trials();

    public double probability();

    @Override
    default public double minValue() {
        return 0.0;
    }

    @Override
    default public double maxValue() {
        return this.trials();
    }

    @Override
    default public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }

    public record Direct(int trials, double probability) implements BinomialSampler
    {
        @Override
        public double sample(long hashedSeed) {
            int successes = 0;
            for (int i = 0; i < this.trials; ++i) {
                if (RandomSampler.sampleDouble(hashedSeed) < this.probability) {
                    ++successes;
                }
                hashedSeed = RandomSampler.mix(hashedSeed);
            }
            return successes;
        }
    }

    public record Poisson(int trials, double probability, PoissonSampler randPoisson) implements BinomialSampler
    {
        @Override
        public double sample(long hashedSeed) {
            return this.randPoisson.sample(hashedSeed);
        }
    }

    public record Normal(int trials, double probability, NormalSampler normalSampler) implements BinomialSampler
    {
        @Override
        public double sample(long hashedSeed) {
            return StrictMath.max(0.0, (double)StrictMath.min((long)this.trials, StrictMath.round(this.normalSampler.sample(hashedSeed))));
        }
    }

    public record Exponential(int trials, double probability, ExponentialSampler exponentialSampler) implements BinomialSampler
    {
        @Override
        public double sample(long hashedSeed) {
            int x = 0;
            double sum = 0.0;
            while (sum <= (double)this.trials) {
                sum += this.exponentialSampler.sample(hashedSeed);
                hashedSeed = RandomSampler.mix(hashedSeed);
                ++x;
            }
            return x - 1;
        }
    }
}

