/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.InflaterInputStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record SingleChannelImageTessellation(int xSize, int zSize, byte[] inflatedFrameData) implements DensityFunction
{
    private static final MapCodec<SingleChannelImageTessellation> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("x_size").forGetter(SingleChannelImageTessellation::xSize), (App)ExtraCodecs.f_144629_.fieldOf("z_size").forGetter(SingleChannelImageTessellation::zSize), (App)ExtraCodecs.f_216160_.fieldOf("deflated_frame_data").forGetter(SingleChannelImageTessellation::inflatedFrameData)).apply((Applicative)instance, SingleChannelImageTessellation::create));
    public static final TypedCodec<SingleChannelImageTessellation> TYPED_CODEC = new TypedCodec("single_channel_image_tessellation", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static SingleChannelImageTessellation create(int xSize, int zSize, byte[] deflatedFrameData) {
        byte[] inflatedBytes;
        try {
            InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(deflatedFrameData));
            inflatedBytes = inflaterStream.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error: More Density Functions failed to decompress frame data", e);
        }
        return new SingleChannelImageTessellation(xSize, zSize, inflatedBytes);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int x = pos.m_207115_();
        int z = pos.m_207113_();
        int arrayPos = StrictMath.floorMod(x, this.xSize) + StrictMath.floorMod(z, this.zSize) * this.xSize;
        return this.inflatedFrameData[arrayPos] & 0xFF;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new SingleChannelImageTessellation(this.xSize, this.zSize, this.inflatedFrameData));
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return 255.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }
}

