/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record GradientMagnitude(DensityFunction arg, int stepX, int stepY, int stepZ) implements DensityFunction
{
    public static final MapCodec<GradientMagnitude> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(GradientMagnitude::arg), (App)ExtraCodecs.f_144628_.fieldOf("step_x").orElse((Object)0).forGetter(GradientMagnitude::stepX), (App)ExtraCodecs.f_144628_.fieldOf("step_y").orElse((Object)0).forGetter(GradientMagnitude::stepY), (App)ExtraCodecs.f_144628_.fieldOf("step_z").orElse((Object)0).forGetter(GradientMagnitude::stepZ)).apply((Applicative)instance, GradientMagnitude::create));
    public static final TypedCodec<GradientMagnitude> TYPED_CODEC = new TypedCodec("gradient_magnitude", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static GradientMagnitude create(DensityFunction arg, int stepX, int stepY, int stepZ) {
        if ((stepX | stepY | stepZ) == 0) {
            throw new IllegalArgumentException("Gradient Magnitude must contain at least one non-zero step component!");
        }
        return new GradientMagnitude(arg, stepX, stepY, stepZ);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int x = pos.m_207115_();
        int y = pos.m_207114_();
        int z = pos.m_207113_();
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.stepX != 0) {
            gradX = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x + this.stepX, y, z)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x - this.stepX, y, z))) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            gradY = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y + this.stepY, z)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y - this.stepY, z))) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            gradZ = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y, z + this.stepZ)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y, z - this.stepZ))) / (2.0 * (double)this.stepZ);
        }
        if (this.stepY == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradX);
        }
        if (this.stepX == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradY);
        }
        if (this.stepX == 0 && this.stepY == 0) {
            return StrictMath.abs(gradZ);
        }
        return StrictMath.sqrt(gradX * gradX + gradY * gradY + gradZ * gradZ);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new GradientMagnitude(this.arg.m_207456_(visitor), this.stepX, this.stepY, this.stepZ));
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public double m_207402_() {
        double minGradX = 0.0;
        double minGradY = 0.0;
        double minGradZ = 0.0;
        if (this.stepX != 0) {
            minGradX = (this.arg.m_207402_() - this.arg.m_207401_()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            minGradY = (this.arg.m_207402_() - this.arg.m_207401_()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            minGradZ = (this.arg.m_207402_() - this.arg.m_207401_()) / (2.0 * (double)this.stepZ);
        }
        return minGradX * minGradX + minGradY * minGradY + minGradZ * minGradZ;
    }

    public double m_207401_() {
        double maxGradX = 0.0;
        double maxGradY = 0.0;
        double maxGradZ = 0.0;
        if (this.stepX != 0) {
            maxGradX = (this.arg.m_207401_() - this.arg.m_207402_()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            maxGradY = (this.arg.m_207401_() - this.arg.m_207402_()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            maxGradZ = (this.arg.m_207401_() - this.arg.m_207402_()) / (2.0 * (double)this.stepZ);
        }
        return maxGradX * maxGradX + maxGradY * maxGradY + maxGradZ * maxGradZ;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }

    private static final class BlockContext
    extends Record
    implements DensityFunction.FunctionContext {
        private final int blockX;
        private final int blockY;
        private final int blockZ;

        private BlockContext(int blockX, int blockY, int blockZ) {
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this, o);
        }

        public int m_207115_() {
            return this.blockX;
        }

        public int m_207114_() {
            return this.blockY;
        }

        public int m_207113_() {
            return this.blockZ;
        }
    }
}

