/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record DotProduct(DensityFunction arg1, DensityFunction arg2, int stepX, int stepY, int stepZ) implements DensityFunction
{
    public static final MapCodec<DotProduct> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument1").forGetter(DotProduct::arg1), (App)DensityFunction.f_208218_.fieldOf("argument2").forGetter(DotProduct::arg2), (App)ExtraCodecs.f_144628_.fieldOf("step_x").orElse((Object)0).forGetter(DotProduct::stepX), (App)ExtraCodecs.f_144628_.fieldOf("step_y").orElse((Object)0).forGetter(DotProduct::stepY), (App)ExtraCodecs.f_144628_.fieldOf("step_z").orElse((Object)0).forGetter(DotProduct::stepZ)).apply((Applicative)instance, DotProduct::create));
    public static final TypedCodec<DotProduct> TYPED_CODEC = new TypedCodec("dot_product", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static DotProduct create(DensityFunction arg1, DensityFunction arg2, int stepX, int stepY, int stepZ) {
        if ((stepX | stepY | stepZ) == 0) {
            throw new IllegalArgumentException("Dot Product must contain at least one non-zero step component!");
        }
        return new DotProduct(arg1, arg2, stepX, stepY, stepZ);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        BlockContext posBackwards;
        BlockContext posForwards;
        int x = pos.m_207115_();
        int y = pos.m_207114_();
        int z = pos.m_207113_();
        double gradX1 = 0.0;
        double gradY1 = 0.0;
        double gradZ1 = 0.0;
        double gradX2 = 0.0;
        double gradY2 = 0.0;
        double gradZ2 = 0.0;
        if (this.stepX != 0) {
            posForwards = new BlockContext(x + this.stepX, y, z);
            posBackwards = new BlockContext(x - this.stepX, y, z);
            gradX1 = (this.arg1.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg1.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepX);
            gradX2 = (this.arg2.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg2.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            posForwards = new BlockContext(x, y + this.stepY, z);
            posBackwards = new BlockContext(x, y - this.stepY, z);
            gradY1 = (this.arg1.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg1.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepY);
            gradY2 = (this.arg2.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg2.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            posForwards = new BlockContext(x, y, z + this.stepZ);
            posBackwards = new BlockContext(x, y, z - this.stepZ);
            gradZ1 = (this.arg1.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg1.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepZ);
            gradZ2 = (this.arg2.m_207386_((DensityFunction.FunctionContext)posForwards) - this.arg2.m_207386_((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepZ);
        }
        return gradX1 * gradX2 + gradY1 * gradY2 + gradZ1 * gradZ2;
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new DotProduct(this.arg1.m_207456_(visitor), this.arg2.m_207456_(visitor), this.stepX, this.stepY, this.stepZ));
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public double m_207402_() {
        double minGradX1 = 0.0;
        double minGradY1 = 0.0;
        double minGradZ1 = 0.0;
        double minGradX2 = 0.0;
        double minGradY2 = 0.0;
        double minGradZ2 = 0.0;
        if (this.stepX != 0) {
            minGradX1 = (this.arg1.m_207402_() - this.arg1.m_207401_()) / (2.0 * (double)this.stepX);
            minGradX2 = (this.arg2.m_207402_() - this.arg2.m_207401_()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            minGradY1 = (this.arg1.m_207402_() - this.arg1.m_207401_()) / (2.0 * (double)this.stepY);
            minGradY2 = (this.arg2.m_207402_() - this.arg2.m_207401_()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            minGradZ1 = (this.arg1.m_207402_() - this.arg1.m_207401_()) / (2.0 * (double)this.stepZ);
            minGradZ2 = (this.arg2.m_207402_() - this.arg2.m_207401_()) / (2.0 * (double)this.stepZ);
        }
        return minGradX1 * minGradX2 + minGradY1 * minGradY2 + minGradZ1 * minGradZ2;
    }

    public double m_207401_() {
        double maxGradX1 = 0.0;
        double maxGradY1 = 0.0;
        double maxGradZ1 = 0.0;
        double maxGradX2 = 0.0;
        double maxGradY2 = 0.0;
        double maxGradZ2 = 0.0;
        if (this.stepX != 0) {
            maxGradX1 = (this.arg1.m_207401_() - this.arg1.m_207402_()) / (2.0 * (double)this.stepX);
            maxGradX2 = (this.arg2.m_207401_() - this.arg2.m_207402_()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            maxGradY1 = (this.arg1.m_207401_() - this.arg1.m_207402_()) / (2.0 * (double)this.stepY);
            maxGradY2 = (this.arg2.m_207401_() - this.arg2.m_207402_()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            maxGradZ1 = (this.arg1.m_207401_() - this.arg1.m_207402_()) / (2.0 * (double)this.stepZ);
            maxGradZ2 = (this.arg2.m_207401_() - this.arg2.m_207402_()) / (2.0 * (double)this.stepZ);
        }
        return maxGradX1 * maxGradX2 + maxGradY1 * maxGradY2 + maxGradZ1 * maxGradZ2;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }

    private static final class BlockContext
    extends Record
    implements DensityFunction.FunctionContext {
        private final int blockX;
        private final int blockY;
        private final int blockZ;

        private BlockContext(int blockX, int blockY, int blockZ) {
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this, o);
        }

        public int m_207115_() {
            return this.blockX;
        }

        public int m_207114_() {
            return this.blockY;
        }

        public int m_207113_() {
            return this.blockZ;
        }
    }
}

