/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Derivative(DensityFunction arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) implements DensityFunction
{
    private static final MapCodec<Derivative> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(Derivative::arg), (App)DerivativeComponent.CODEC.fieldOf("component_x").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentX), (App)DerivativeComponent.CODEC.fieldOf("component_y").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentY), (App)DerivativeComponent.CODEC.fieldOf("component_z").orElse((Object)DerivativeComponent.NONE).forGetter(Derivative::componentZ)).apply((Applicative)instance, Derivative::create));
    public static final TypedCodec<Derivative> TYPED_CODEC = new TypedCodec("derivative", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static Derivative create(DensityFunction arg, DerivativeComponent componentX, DerivativeComponent componentY, DerivativeComponent componentZ) {
        if ((componentX.step | componentY.step | componentZ.step) == 0) {
            throw new IllegalArgumentException("Derivative must contain at least one non-trivial directional component!");
        }
        return new Derivative(arg, componentX, componentY, componentZ);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int x = pos.m_207115_();
        int y = pos.m_207114_();
        int z = pos.m_207113_();
        double dirX = 0.0;
        double dirY = 0.0;
        double dirZ = 0.0;
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.componentX.step != 0) {
            dirX = this.componentX.direction.m_207386_(pos);
            gradX = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x + this.componentX.step, y, z)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x - this.componentX.step, y, z))) / (2.0 * (double)this.componentX.step);
        }
        if (this.componentY.step != 0) {
            dirY = this.componentY.direction.m_207386_(pos);
            gradY = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y + this.componentY.step, z)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y - this.componentY.step, z))) / (2.0 * (double)this.componentY.step);
        }
        if (this.componentZ.step != 0) {
            dirZ = this.componentZ.direction.m_207386_(pos);
            gradZ = (this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y, z + this.componentZ.step)) - this.arg.m_207386_((DensityFunction.FunctionContext)new BlockContext(x, y, z - this.componentZ.step))) / (2.0 * (double)this.componentZ.step);
        }
        if (this.componentY.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirX) * gradX;
        }
        if (this.componentX.step == 0 && this.componentZ.step == 0) {
            return StrictMath.signum(dirY) * gradY;
        }
        if (this.componentX.step == 0 && this.componentY.step == 0) {
            return StrictMath.signum(dirZ) * gradZ;
        }
        double magnitude = StrictMath.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        return magnitude == 0.0 ? 0.0 : (dirX * gradX + dirY * gradY + dirZ * gradZ) / magnitude;
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        this.componentX.direction.m_207456_(visitor);
        this.componentY.direction.m_207456_(visitor);
        this.componentZ.direction.m_207456_(visitor);
        return visitor.m_214017_((DensityFunction)new Derivative(this.arg.m_207456_(visitor), this.componentX, this.componentY, this.componentZ));
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public double m_207402_() {
        return -1.7976931348623157E308;
    }

    public double m_207401_() {
        return Double.MAX_VALUE;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }

    private record DerivativeComponent(int step, DensityFunction direction) {
        static final Codec<DerivativeComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("step").forGetter(DerivativeComponent::step), (App)DensityFunction.f_208218_.fieldOf("direction").forGetter(DerivativeComponent::direction)).apply((Applicative)instance, DerivativeComponent::new));
        static final DerivativeComponent NONE = new DerivativeComponent(0, DensityFunctions.m_208264_((double)0.0));
    }

    private static final class BlockContext
    extends Record
    implements DensityFunction.FunctionContext {
        private final int blockX;
        private final int blockY;
        private final int blockZ;

        private BlockContext(int blockX, int blockY, int blockZ) {
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockContext.class, "blockX;blockY;blockZ", "blockX", "blockY", "blockZ"}, this, o);
        }

        public int m_207115_() {
            return this.blockX;
        }

        public int m_207114_() {
            return this.blockY;
        }

        public int m_207113_() {
            return this.blockZ;
        }
    }
}

