/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStack
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStack(FluidStack fluidStack) {
        this.stack = fluidStack;
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public long getAmount() {
        return this.getInternal().getAmount();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        FluidStack copy = this.getInternal().copy();
        copy.setAmount(amount);
        return IFluidStack.of(copy);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public Fluid getFluid() {
        return this.getInternal().getFluid();
    }

    @Override
    public IFluidStack withTag(@ZenCodeType.Nullable IData tag) {
        FluidStack copy = this.getInternal().copy();
        if (tag != null) {
            MapData map = new MapData(tag.asMap());
            copy.setTag(map.getInternal());
        } else {
            copy.setTag(null);
        }
        return IFluidStack.of(copy);
    }

    @Override
    public boolean hasTag() {
        return this.getInternal().hasTag();
    }

    @Override
    public IData getTag() {
        return TagToDataConverter.convert((Tag)this.getInternal().getTag());
    }

    public FluidStack getInternal() {
        return this.stack;
    }

    public FluidStack getImmutableInternal() {
        return this.stack;
    }

    @Override
    public IData asIData() {
        IData data = IFluidStack.super.asIData();
        data.put("amount", new IntData(Math.toIntExact(this.getAmount())));
        return data;
    }

    @Override
    public CompoundTag getInternalTag() {
        return this.getInternal().getTag();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStack)o).getInternal();
        FluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().getAmount(), this.getInternal().getFluid(), this.getInternal().getTag());
    }
}

