/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.BiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.FilterableWeightedList;
import io.github.apace100.calio.data.DataException;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.calio.mixin.WeightedListEntryAccessor;
import io.github.apace100.calio.util.ArgumentWrapper;
import io.github.apace100.calio.util.TagLike;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class SerializableDataType<T> {
    private final Class<T> dataClass;
    private final BiConsumer<class_2540, T> send;
    private final Function<class_2540, T> receive;
    private final Function<JsonElement, T> read;

    public SerializableDataType(Class<T> dataClass, BiConsumer<class_2540, T> send, Function<class_2540, T> receive, Function<JsonElement, T> read) {
        this.dataClass = dataClass;
        this.send = send;
        this.receive = receive;
        this.read = read;
    }

    public void send(class_2540 buffer, Object value) {
        this.send.accept(buffer, (class_2540)this.cast(value));
    }

    public T receive(class_2540 buffer) {
        return this.receive.apply(buffer);
    }

    public T read(JsonElement jsonElement) {
        return this.read.apply(jsonElement);
    }

    public T cast(Object data) {
        return this.dataClass.cast(data);
    }

    public static <T> SerializableDataType<List<T>> list(SerializableDataType<T> singleDataType) {
        return new SerializableDataType<List<T>>(ClassUtil.castClass(List.class), (buf, list) -> {
            buf.writeInt(list.size());
            int i = 0;
            for (Object elem : list) {
                try {
                    singleDataType.send((class_2540)buf, elem);
                }
                catch (DataException e) {
                    throw e.prepend("[" + i + "]");
                }
                catch (Exception e) {
                    throw new DataException(DataException.Phase.WRITING, "[" + i + "]", e);
                }
                ++i;
            }
        }, buf -> {
            int count = buf.readInt();
            LinkedList list = new LinkedList();
            for (int i = 0; i < count; ++i) {
                try {
                    list.add(singleDataType.receive((class_2540)buf));
                    continue;
                }
                catch (DataException e) {
                    throw e.prepend("[" + i + "]");
                }
                catch (Exception e) {
                    throw new DataException(DataException.Phase.RECEIVING, "[" + i + "]", e);
                }
            }
            return list;
        }, json -> {
            LinkedList list = new LinkedList();
            if (json.isJsonArray()) {
                int i = 0;
                for (JsonElement je : json.getAsJsonArray()) {
                    try {
                        list.add(singleDataType.read(je));
                    }
                    catch (DataException e) {
                        throw e.prepend("[" + i + "]");
                    }
                    catch (Exception e) {
                        throw new DataException(DataException.Phase.READING, "[" + i + "]", e);
                    }
                    ++i;
                }
            } else {
                list.add(singleDataType.read((JsonElement)json));
            }
            return list;
        });
    }

    public static <T> SerializableDataType<FilterableWeightedList<T>> weightedList(SerializableDataType<T> singleDataType) {
        return new SerializableDataType<FilterableWeightedList<T>>(ClassUtil.castClass(FilterableWeightedList.class), (buf, list) -> {
            buf.writeInt(list.size());
            AtomicInteger i = new AtomicInteger();
            list.entryStream().forEach(entry -> {
                try {
                    singleDataType.send((class_2540)buf, entry.method_35095());
                    buf.writeInt(((WeightedListEntryAccessor)entry).getWeight());
                }
                catch (DataException e) {
                    throw e.prepend("[" + i.get() + "]");
                }
                catch (Exception e) {
                    throw new DataException(DataException.Phase.WRITING, "[" + i.get() + "]", e);
                }
                i.getAndIncrement();
            });
        }, buf -> {
            int count = buf.readInt();
            FilterableWeightedList list = new FilterableWeightedList();
            for (int i = 0; i < count; ++i) {
                try {
                    Object t = singleDataType.receive((class_2540)buf);
                    int weight = buf.readInt();
                    list.method_35093(t, weight);
                    continue;
                }
                catch (DataException e) {
                    throw e.prepend("[" + i + "]");
                }
                catch (Exception e) {
                    throw new DataException(DataException.Phase.RECEIVING, "[" + i + "]", e);
                }
            }
            return list;
        }, json -> {
            FilterableWeightedList list = new FilterableWeightedList();
            if (json.isJsonArray()) {
                int i = 0;
                for (JsonElement je : json.getAsJsonArray()) {
                    try {
                        JsonObject weightedObj = je.getAsJsonObject();
                        Object elem = singleDataType.read(weightedObj.get("element"));
                        int weight = class_3518.method_15260((JsonObject)weightedObj, (String)"weight");
                        list.method_35093(elem, weight);
                    }
                    catch (DataException e) {
                        throw e.prepend("[" + i + "]");
                    }
                    catch (Exception e) {
                        throw new DataException(DataException.Phase.READING, "[" + i + "]", e);
                    }
                    ++i;
                }
            }
            return list;
        });
    }

    public static <T> SerializableDataType<T> registry(Class<T> dataClass, class_2378<T> registry) {
        return SerializableDataType.wrap(dataClass, SerializableDataTypes.IDENTIFIER, arg_0 -> registry.method_10221(arg_0), id -> {
            Optional optional = registry.method_17966(id);
            if (optional.isPresent()) {
                return optional.get();
            }
            throw new RuntimeException("Identifier \"" + id + "\" was not registered in registry \"" + registry.method_30517().method_29177() + "\".");
        });
    }

    public static <T> SerializableDataType<T> compound(Class<T> dataClass, SerializableData data, Function<SerializableData.Instance, T> toInstance, BiFunction<SerializableData, T, SerializableData.Instance> toData) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> data.write((class_2540)buf, (SerializableData.Instance)toData.apply(data, t)), buf -> toInstance.apply(data.read((class_2540)buf)), json -> toInstance.apply(data.read(json.getAsJsonObject())));
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass) {
        return SerializableDataType.enumValue(dataClass, null);
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass, HashMap<String, T> additionalMap) {
        return new SerializableDataType<Enum>(dataClass, (buf, t) -> buf.writeInt(t.ordinal()), buf -> ((Enum[])dataClass.getEnumConstants())[buf.readInt()], json -> {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    int enumOrdinal = primitive.getAsInt();
                    Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                    if (enumOrdinal < 0 || enumOrdinal >= enumValues.length) {
                        throw new JsonSyntaxException("Expected to be in the range of 0 - " + (enumValues.length - 1));
                    }
                    return enumValues[enumOrdinal];
                }
                if (primitive.isString()) {
                    String enumName = primitive.getAsString();
                    try {
                        Object t = Enum.valueOf(dataClass, enumName);
                        return t;
                    }
                    catch (IllegalArgumentException e0) {
                        try {
                            Object t = Enum.valueOf(dataClass, enumName.toUpperCase(Locale.ROOT));
                            return t;
                        }
                        catch (IllegalArgumentException e1) {
                            try {
                                if (additionalMap == null || !additionalMap.containsKey(enumName)) {
                                    throw new IllegalArgumentException();
                                }
                                Enum t = (Enum)additionalMap.get(enumName);
                                return t;
                            }
                            catch (IllegalArgumentException e2) {
                                Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                                String stringOf = enumValues[0].name() + ", " + enumValues[0].name().toLowerCase(Locale.ROOT);
                                for (int i = 1; i < enumValues.length; ++i) {
                                    stringOf = stringOf + ", " + enumValues[i].name() + ", " + enumValues[i].name().toLowerCase(Locale.ROOT);
                                }
                                throw new JsonSyntaxException("Expected value to be a string of: " + stringOf);
                            }
                        }
                    }
                }
            }
            throw new JsonSyntaxException("Expected value to be either an integer or a string.");
        });
    }

    public static <T> SerializableDataType<T> mapped(Class<T> dataClass, BiMap<String, T> map) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> buf.method_10814((String)map.inverse().get(t)), buf -> map.get((Object)buf.method_10800(Short.MAX_VALUE)), json -> {
            JsonPrimitive primitive;
            if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
                String name = primitive.getAsString();
                try {
                    if (map == null || !map.containsKey((Object)name)) {
                        throw new IllegalArgumentException();
                    }
                    Object t = map.get((Object)name);
                    return t;
                }
                catch (IllegalArgumentException e2) {
                    throw new JsonSyntaxException("Expected value to be a string of: " + map.keySet().stream().reduce((s0, s1) -> s0 + ", " + s1));
                }
            }
            throw new JsonSyntaxException("Expected value to be a string.");
        });
    }

    public static <T, U> SerializableDataType<T> wrap(Class<T> dataClass, SerializableDataType<U> base, Function<T, U> toFunction, Function<U, T> fromFunction) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> base.send((class_2540)buf, toFunction.apply(t)), buf -> fromFunction.apply(base.receive((class_2540)buf)), json -> fromFunction.apply(base.read((JsonElement)json)));
    }

    public static <T> SerializableDataType<class_6862<T>> tag(class_5321<? extends class_2378<T>> registryKey) {
        return SerializableDataType.wrap(ClassUtil.castClass(class_6862.class), SerializableDataTypes.IDENTIFIER, class_6862::comp_327, id -> class_6862.method_40092((class_5321)registryKey, (class_2960)id));
    }

    public static <T> SerializableDataType<class_5321<T>> registryKey(class_5321<class_2378<T>> registryKeyRegistry) {
        return SerializableDataType.wrap(ClassUtil.castClass(class_5321.class), SerializableDataTypes.IDENTIFIER, class_5321::method_29177, identifier -> class_5321.method_29179((class_5321)registryKeyRegistry, (class_2960)identifier));
    }

    public static <T extends Enum<T>> SerializableDataType<EnumSet<T>> enumSet(Class<T> enumClass, SerializableDataType<T> enumDataType) {
        return new SerializableDataType<EnumSet<T>>(ClassUtil.castClass(EnumSet.class), (buf, set) -> {
            buf.writeInt(set.size());
            set.forEach(t -> buf.writeInt(t.ordinal()));
        }, buf -> {
            int size = buf.readInt();
            EnumSet<Enum> set = EnumSet.noneOf(enumClass);
            Enum[] allValues = (Enum[])enumClass.getEnumConstants();
            for (int i = 0; i < size; ++i) {
                int ordinal = buf.readInt();
                set.add(allValues[ordinal]);
            }
            return set;
        }, json -> {
            EnumSet<Enum> set = EnumSet.noneOf(enumClass);
            if (json.isJsonPrimitive()) {
                Enum t = (Enum)enumDataType.read.apply((JsonElement)json);
                set.add(t);
            } else if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                for (JsonElement jsonElement : array) {
                    Enum t = (Enum)enumDataType.read.apply(jsonElement);
                    set.add(t);
                }
            } else {
                throw new RuntimeException("Expected enum set to be either an array or a primitive.");
            }
            return set;
        });
    }

    public static <T, U extends ArgumentType<T>> SerializableDataType<ArgumentWrapper<T>> argumentType(U argumentType) {
        return SerializableDataType.wrap(ClassUtil.castClass(ArgumentWrapper.class), SerializableDataTypes.STRING, ArgumentWrapper::rawArgument, str -> {
            try {
                Object t = argumentType.parse(new StringReader(str));
                return new ArgumentWrapper<Object>(t, (String)str);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Wrong syntax in argument type data", e);
            }
        });
    }

    public static <T> SerializableDataType<TagLike<T>> tagLike(class_2378<T> registry) {
        return new SerializableDataType<TagLike<T>>(ClassUtil.castClass(TagLike.class), (packetByteBuf, tagLike) -> tagLike.write((class_2540)packetByteBuf), packetByteBuf -> {
            TagLike tagLike = new TagLike(registry);
            tagLike.read((class_2540)packetByteBuf);
            return tagLike;
        }, jsonElement -> {
            TagLike tagLike = new TagLike(registry);
            if (!jsonElement.isJsonArray()) {
                throw new JsonSyntaxException("Expected a JSON array,");
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            jsonArray.forEach(je -> {
                String s = je.getAsString();
                if (s.startsWith("#")) {
                    class_2960 id = new class_2960(s.substring(1));
                    tagLike.addTag(id);
                } else {
                    tagLike.add(new class_2960(s));
                }
            });
            return tagLike;
        });
    }
}

