/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.calio.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MultiJsonDataLoader
extends class_4080<Map<class_2960, List<JsonElement>>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String dataType;

    public MultiJsonDataLoader(Gson gson, String dataType) {
        this.gson = gson;
        this.dataType = dataType;
    }

    protected Map<class_2960, List<JsonElement>> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        int i = this.dataType.length() + 1;
        Iterator var5 = resourceManager.method_14488(this.dataType, id -> id.method_12832().endsWith(".json")).entrySet().iterator();
        HashSet resourcesHandled = new HashSet();
        while (var5.hasNext()) {
            class_2960 identifier = (class_2960)var5.next().getKey();
            String string = identifier.method_12832();
            class_2960 identifier2 = new class_2960(identifier.method_12836(), string.substring(i, string.length() - FILE_SUFFIX_LENGTH));
            resourcesHandled.clear();
            resourceManager.method_14489(identifier).forEach(resource -> {
                if (!resourcesHandled.contains(resource.method_14480())) {
                    resourcesHandled.add(resource.method_14480());
                    try {
                        Throwable var10 = null;
                        try (InputStream inputStream = resource.method_14482();
                             BufferedReader reader = resource.method_43039();){
                            JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                            if (jsonElement != null) {
                                if (map.containsKey(identifier2)) {
                                    ((List)map.get(identifier2)).add(jsonElement);
                                } else {
                                    LinkedList<JsonElement> elementList = new LinkedList<JsonElement>();
                                    elementList.add(jsonElement);
                                    map.put(identifier2, elementList);
                                }
                            } else {
                                LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)identifier2, (Object)identifier);
                            }
                        }
                        catch (Throwable var66) {
                            var10 = var66;
                            throw var66;
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException var68) {
                        LOGGER.error("Couldn't parse data file {} from {}", (Object)identifier2, (Object)identifier, (Object)var68);
                    }
                }
            });
        }
        return map;
    }
}

