/*
 * Decompiled with CFR 0.152.
 */
package io.github.steelwoolmc.mixintransmog;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.LoadingModList;

public class GeneratedMixinClassesSecureJar
implements SecureJar {
    private final SecureJar.ModuleDataProvider moduleDataProvider = new GeneratedMixinClassesModuleDataProvider();

    public SecureJar.ModuleDataProvider moduleDataProvider() {
        return this.moduleDataProvider;
    }

    public Path getPrimaryPath() {
        return Path.of(this.moduleDataProvider().uri());
    }

    public CodeSigner[] getManifestSigners() {
        return new CodeSigner[0];
    }

    public SecureJar.Status verifyPath(Path path) {
        return SecureJar.Status.NONE;
    }

    public SecureJar.Status getFileStatus(String name) {
        return SecureJar.Status.NONE;
    }

    public Attributes getTrustedManifestEntries(String name) {
        return new Attributes();
    }

    public boolean hasSecurityData() {
        return false;
    }

    public Set<String> getPackages() {
        return this.moduleDataProvider().descriptor().packages();
    }

    public List<SecureJar.Provider> getProviders() {
        return List.of();
    }

    public String name() {
        return this.moduleDataProvider().name();
    }

    public Path getPath(String first, String ... rest) {
        return this.getPrimaryPath();
    }

    public Path getRootPath() {
        return this.getPrimaryPath();
    }

    private static class GeneratedMixinClassesModuleDataProvider
    implements SecureJar.ModuleDataProvider {
        private ModuleDescriptor descriptor;

        private GeneratedMixinClassesModuleDataProvider() {
        }

        public String name() {
            return "mixin_generated_classes";
        }

        public ModuleDescriptor descriptor() {
            if (this.descriptor == null) {
                String argsPkg = "org.spongepowered.asm.synthetic.args";
                boolean exists = LoadingModList.get().getModFiles().stream().anyMatch(modFileInfo -> modFileInfo.getFile().getSecureJar().getPackages().contains(argsPkg));
                this.descriptor = ModuleDescriptor.newAutomaticModule(this.name()).packages(exists ? Set.of() : Set.of("org.spongepowered.asm.synthetic", argsPkg)).build();
            }
            return this.descriptor;
        }

        public URI uri() {
            return (URI)LamdbaExceptionUtils.uncheck(() -> new URI("file:///~nonexistent"));
        }

        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        public Optional<InputStream> open(String name) {
            return Optional.empty();
        }

        public Manifest getManifest() {
            return new Manifest();
        }

        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return new CodeSigner[0];
        }
    }
}

