/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util.modifier;

import io.github.apace100.apoli.util.modifier.IModifierOperation;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierOperation;
import io.github.apace100.calio.data.SerializableData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1322;

public class ModifierUtil {
    public static Modifier createSimpleModifier(IModifierOperation operation, double value) {
        SerializableData.Instance data = new SerializableData.Instance(ModifierOperation.DATA);
        data.set("value", (Object)value);
        data.set("resource", null);
        data.set("modifier", null);
        return new Modifier(operation, data);
    }

    public static Modifier fromAttributeModifier(class_1322 attributeModifier) {
        ModifierOperation operation = null;
        switch (attributeModifier.method_6182()) {
            case field_6328: {
                operation = ModifierOperation.ADD_BASE_EARLY;
                break;
            }
            case field_6330: {
                operation = ModifierOperation.MULTIPLY_BASE_ADDITIVE;
                break;
            }
            case field_6331: {
                operation = ModifierOperation.MULTIPLY_TOTAL_MULTIPLICATIVE;
            }
        }
        if (operation == null) {
            throw new RuntimeException("Could not construct generic modifier from attribute modifier. Unknown operation: " + String.valueOf(attributeModifier.method_6182()));
        }
        return ModifierUtil.createSimpleModifier(operation, attributeModifier.method_6186());
    }

    public static Map<IModifierOperation, List<SerializableData.Instance>> sortModifiers(List<Modifier> modifiers) {
        HashMap<IModifierOperation, List<SerializableData.Instance>> buckets = new HashMap<IModifierOperation, List<SerializableData.Instance>>();
        for (Modifier modifier : modifiers) {
            List list = buckets.computeIfAbsent(modifier.getOperation(), op -> new LinkedList());
            list.add(modifier.getData());
        }
        return buckets;
    }

    public static double applyModifiers(class_1297 entity, List<Modifier> modifiers, double baseValue) {
        return ModifierUtil.applyModifiers(entity, ModifierUtil.sortModifiers(modifiers), baseValue);
    }

    public static double applyModifiers(class_1297 entity, Map<IModifierOperation, List<SerializableData.Instance>> modifiers, double baseValue) {
        double currentBase = baseValue;
        double currentValue = baseValue;
        LinkedList<IModifierOperation> operations = new LinkedList<IModifierOperation>(modifiers.keySet());
        operations.sort((o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getPhase() == o2.getPhase()) {
                return o1.getOrder() - o2.getOrder();
            }
            return o1.getPhase().ordinal() - o2.getPhase().ordinal();
        });
        IModifierOperation.Phase lastPhase = IModifierOperation.Phase.BASE;
        for (IModifierOperation op : operations) {
            List<SerializableData.Instance> data = modifiers.get(op);
            if (op.getPhase() != lastPhase) {
                currentBase = currentValue;
            }
            currentValue = op.apply(entity, data, currentBase, currentValue);
        }
        return currentValue;
    }
}

