/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.util;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.util.PowerGrantingItem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public final class StackPowerUtil {
    public static void addPower(class_1799 stack, class_1304 slot, class_2960 powerId) {
        StackPowerUtil.addPower(stack, slot, powerId, false, false);
    }

    public static void addPower(class_1799 stack, class_1304 slot, class_2960 powerId, boolean isHidden, boolean isNegative) {
        StackPower stackPower = new StackPower();
        stackPower.slot = slot;
        stackPower.powerId = powerId;
        stackPower.isHidden = isHidden;
        stackPower.isNegative = isNegative;
        StackPowerUtil.addPower(stack, stackPower);
    }

    public static void addPower(class_1799 stack, StackPower stackPower) {
        class_2499 list;
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("Powers")) {
            class_2520 elem = nbt.method_10580("Powers");
            if (elem.method_10711() != 9) {
                Apoli.LOGGER.warn("Can't add power " + String.valueOf(stackPower.powerId) + " to item stack " + String.valueOf(stack) + ", as it contains conflicting NBT data.");
                return;
            }
            list = (class_2499)elem;
        } else {
            list = new class_2499();
            nbt.method_10566("Powers", (class_2520)list);
        }
        list.add((Object)stackPower.toNbt());
    }

    public static void removePower(class_1799 stack, class_1304 slot, class_2960 powerId) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("Powers")) {
            class_2520 elem = nbt.method_10580("Powers");
            if (elem.method_10711() != 9) {
                Apoli.LOGGER.warn("Can't remove power " + String.valueOf(powerId) + " from item stack " + String.valueOf(stack) + ", as it contains conflicting NBT data.");
                return;
            }
            class_2499 list = (class_2499)elem;
            int found = -1;
            while (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    StackPower sp = StackPower.fromNbt(list.method_10602(i));
                    if (!sp.powerId.equals((Object)powerId) || sp.slot != slot) continue;
                    found = i;
                    break;
                }
                if (found < 0) break;
                list.method_10536(found);
                found = -1;
            }
        }
    }

    public static List<StackPower> getPowers(class_1799 stack, class_1304 slot) {
        class_2487 nbt = stack.method_7969();
        LinkedList<StackPower> powers = new LinkedList<StackPower>();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof PowerGrantingItem) {
            PowerGrantingItem pgi = (PowerGrantingItem)class_17922;
            powers.addAll(pgi.getPowers(stack, slot));
        }
        if (nbt != null && nbt.method_10545("Powers")) {
            class_2520 elem = nbt.method_10580("Powers");
            if (elem.method_10711() != 9) {
                return List.of();
            }
            class_2499 list = (class_2499)elem;
            list.stream().map(p -> {
                if (p.method_10711() == 10) {
                    return StackPower.fromNbt((class_2487)p);
                }
                Apoli.LOGGER.warn("Invalid power format on stack nbt, stack = " + String.valueOf(stack) + ", nbt = " + String.valueOf(p));
                return null;
            }).filter(sp -> sp != null && sp.slot == slot).forEach(powers::add);
        }
        return powers;
    }

    public static class StackPower {
        public class_1304 slot;
        public class_2960 powerId;
        public boolean isHidden;
        public boolean isNegative;

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("Slot", this.slot.method_5923());
            nbt.method_10582("Power", this.powerId.toString());
            nbt.method_10556("Hidden", this.isHidden);
            nbt.method_10556("Negative", this.isNegative);
            return nbt;
        }

        public static StackPower fromNbt(class_2487 nbt) {
            StackPower stackPower = new StackPower();
            stackPower.slot = class_1304.method_5924((String)nbt.method_10558("Slot"));
            stackPower.powerId = new class_2960(nbt.method_10558("Power"));
            stackPower.isHidden = nbt.method_10545("Hidden") && nbt.method_10577("Hidden");
            stackPower.isNegative = nbt.method_10545("Negative") && nbt.method_10577("Negative");
            return stackPower;
        }
    }
}

